<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Component;

trait BreadcrumbsTrait
{
    /**
     * [
     *     [
     *     'translated'=>[
     *       'name'=>$name
     *     ],
     *     'link'=>$url
     *   ]
     * ]
     * @var array
     */
    protected $path = [];

    public function addBreadcrumb(string $name, string $url): void
    {
        $this->path[] = [
            'translated' => [
                'name' => $name,
            ],
            'name' => $name,
            'link' => $url,
        ];
    }

    public function getBreadcrumbs(): array
    {
        return $this->path;
    }
}
