# Project Summary: topdata-topfinder-pro-sw6

## Overview

This project is a Shopware 6 plugin named "Topdata TopFinder Pro". Its primary purpose is to enhance product discovery within a Shopware store, specifically by allowing users to find products (likely printer components, based on descriptions and naming) that are compatible with specific devices (e.g., printers, referred to as "Geräte" in German). The plugin provides various frontend elements and configuration options to facilitate this device-based product search. It depends on two other Topdata plugins: `topdata-connector-sw6` and `topdata-foundation-sw6`.

## Key Features

*   **Device Finder:** The core feature allows users to select Brand, Series/Type, and Device via dropdown select boxes or a dedicated popup modal to filter and find compatible products.
*   **Storefront Integration:** Adds configurable elements to the storefront:
    *   Device selection dropdowns.
    *   A slider displaying recently viewed devices (history).
    *   An A-Z navigation bar for browsing brands ("ABC Leiste").
    *   A button to trigger the device finder popup.
*   **Product Detail Enhancement:** Adds a "Compatible Devices" tab to product detail pages, listing devices the product works with.
*   **Search Integration:** Can integrate device search capabilities directly into the main shop search bar or provide a separate search field for devices.
*   **Personal Device List:** Allows logged-in users to save their frequently used devices for quick access to compatible products.
*   **Dedicated Device Pages:** Creates specific storefront pages for Brands, Series, Types, and individual Devices, listing associated products. Includes configurable sorting and pagination.
*   **Sitemap Integration:** Adds URLs for Brands, Series, Types, and Devices to the shop's sitemap for SEO purposes.
*   **CMS Integration:** Provides a Shopware CMS block for embedding the TopFinder select boxes (`cms-block-top-finder-selectboxes`).
*   **API Endpoints:** Includes several API controllers (`ApiController_DeviceToCustomer`, `TopFinderApiController`, `TopFinderBrandController`) likely used for AJAX-driven updates in the storefront (e.g., dynamic select box options, search suggestions, managing personal device lists).
*   **Extensive Configuration:** Offers numerous settings via the Shopware Administration panel (`config.xml`), controlling aspects like finder modes, display options, history length, popup appearance, product page tab behavior, search modes, and compact view thresholds.
*   **Cookie Management:** Uses cookies (`TopFinderCookieProvider`) to store user preferences and device history locally.

## Technical Stack

*   **Backend:**
    *   Language: PHP
    *   Framework: Shopware 6 Platform (built on Symfony)
    *   Key Dependencies: `shopware/core`, `topdata/topdata-connector-sw6`, `topdata/topdata-foundation-sw6`
*   **Frontend:**
    *   Templating: Twig (`src/Resources/views/`)
    *   Styling: SCSS (`src/Resources/app/storefront/src/scss/`)
    *   JavaScript: TypeScript (`.ts` files in `src/Resources/app/storefront/src/plugin/`) compiled to JavaScript. Uses custom JS plugins extending Shopware's Storefront Plugin system. Includes the SlimSelect library for dropdowns.
*   **Administration:**
    *   JavaScript: Extends the Shopware Administration UI (`src/Resources/app/administration/`).

## Project Structure (Key Directories)

*   `src/`: Main PHP source code.
    *   `Component/`: Reusable PHP components (e.g., `BreadcrumbsTrait`).
    *   `Content/`: Data-related classes (Entities, Events).
    *   `Controller/`: API and Storefront controllers handling requests.
    *   `Framework/`: Core framework extensions (e.g., `CookieProvider`).
    *   `Resources/`: Plugin assets and configuration.
        *   `app/administration/`: Administration module JS/CSS.
        *   `app/storefront/`: Storefront JS/SCSS/Assets.
            *   `src/plugin/`: Storefront JavaScript plugins (TypeScript).
        *   `config/`: Plugin configuration files (`config.xml`, `services.xml`, `routes.xml`).
        *   `views/`: Storefront Twig templates.
        *   `snippet/`: Language translation files.
    *   `Service/`: Business logic implementation (e.g., `DeviceToCustomerService`).
    *   `Sitemap/`: Sitemap URL providers.
    *   `Storefront/`: Storefront-specific logic.
        *   `Page/`: Page Loaders and data structures for various Storefront views.
    *   `Subscriber/`: Event subscribers listening to Shopware core events.
    *   `Util/`: Utility helper classes.
*   `composer.json`: Defines PHP dependencies, autoloading, and plugin metadata.

## Notable Implementation Details

*   Leverages Shopware's Storefront **Page Loading System** extensively (`src/Storefront/Page/`) to prepare data for different views (e.g., `DevicePageLoader`, `TopfinderPageLoader`).
*   Uses custom **JavaScript plugins** (`.plugin.ts`) that extend Shopware's base JS plugins for interactive frontend features.
*   Functionality is heavily influenced by **configuration settings** defined in `config.xml`.
*   Employs custom **API endpoints** for dynamic frontend interactions without full page reloads.
*   Manages user's device history and personal device list through a combination of **cookies** and backend services (`DeviceToCustomerService`, `ApiController_DeviceToCustomer`).
*   Integrates with Shopware's **CMS system** via a custom block definition.
*   Extends Shopware's **Sitemap generation** to include custom entity URLs.
*   Relies on a foundation plugin (`topdata-foundation-sw6`), suggesting shared code or patterns across Topdata plugins (possibly for configuration handling via `TopConfigRegistryCompilerPass`).
*   Includes specific logic for handling **product listings** on device pages, including sorting and pagination (`ListProductsPageLoader`, `ProductDeviceListingLoader`).