# PHP code style conventions

- the names of a private method should start with an underscore, e.g. `_myPrivateMethod()`
- each class should have a docblock explaining what the class does
- each method should have a docblock explaining what the method does, except setters and getters
- Do NOT add redundant PHPDoc tags to docblocks, e.g. `@return void` or `@param string $foo` without any additional information
- the signature of a method should have type hints for all parameters and the return type 
- when injecting services, use constructor property promotion, and use the `private readonly` visibility modifier for the injected service  
- use `match` instead of `switch` if possible

- the signature of a method should have type hints for all parameters and the return type
- do not add docblocks to setters and getters unless they do something special
- do not add docblocks to constructors unless they do something special
- NEVER use annotations for Routes, ALWAYS use attributes, example: `#[Route('/my-route', name: 'my_route')]`
- when a method or class has already a docblock, do not add another one
