<?php

namespace Topdata\TopdataTopFinderProSW6\FoundationHotfix\Service;


use Topdata\TopdataTopFinderProSW6\FoundationHotfix\Util\CliLogger;

/**
 * 11/2024 created
 */
class CliDumpService
{


    /**
     * @readonly
     */
    private TopConfigRegistry $topConfigRegistry;
    /**
     * @readonly
     */
    private PluginHelperService $pluginHelperService;
    public function __construct(TopConfigRegistry   $topConfigRegistry, PluginHelperService $pluginHelperService)
    {
        $this->topConfigRegistry = $topConfigRegistry;
        $this->pluginHelperService = $pluginHelperService;
    }

    /**
     * list registered plugins in a table
     *
     * 11/2024 created
     */
    public function dumpRegisteredPlugins(): void
    {
        $table = [];
        foreach ($this->topConfigRegistry->getRegisteredTopConfigs() as $topConfig) {
            $table[] = [
                'name'    => $topConfig->getPluginName(),
                'version' => $this->pluginHelperService->getPluginVersion($topConfig->getPluginName()),
                'configs' => count($topConfig->getFlatConfig()),
            ];
        }

        CliLogger::getCliStyle()->listOfDictsAsTable($table, 'Registered Plugins');
    }
}