<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Controller;

use Shopware\Storefront\Controller\StorefrontController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\FoundationHotfix\Util\UtilJsonResponse;
use Topdata\TopdataTopFinderProSW6\Service\DeviceHistoryService_Session;
use Psr\Log\LoggerInterface; // <-- Add Logger

/**
 * API Controller to expose device history stored in the session.
 * Primarily for debugging purposes.
 *
 * 04/2025 created
 * @\Symfony\Component\Routing\Annotation\Route(defaults={"_routeScope"={"storefront"}})
 */
class ApiController_DeviceHistory_Session extends StorefrontController
{
    /**
     * @readonly
     */
    private DeviceHistoryService_Session $deviceHistoryService_Session;
    /**
     * @readonly
     */
    private LoggerInterface $logger;

    public function __construct(DeviceHistoryService_Session $deviceHistoryService_Session, LoggerInterface              $logger)
    {
        $this->deviceHistoryService_Session = $deviceHistoryService_Session;
        $this->logger = $logger;
    }
    /**
     * Retrieves the current device history from the session service.
     * @\Symfony\Component\Routing\Annotation\Route(
     *     path="/top-finder-api/device-history/current",
     *     name="frontend.top-finder-api.device-history.current",
     *     defaults={"XmlHttpRequest": true},
     *     methods={"GET", "POST"}
     * )
     */
    public function getCurrentHistory(): JsonResponse
    {
        $history = $this->deviceHistoryService_Session->getHistory();
        // Log what the service returned just before sending the API response
        $this->logger->info('ApiController_DeviceHistory_Session: Returning history from API: ', is_array($history) ? $history : [$history]);
        return UtilJsonResponse::payload($history);
    }
}