<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder;

use Shopware\Core\Content\Product\SalesChannel\Listing\ProductListingResult;
use Shopware\Storefront\Framework\Page\StorefrontSearchResult;
use Shopware\Storefront\Page\Page;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceEntity;
use Topdata\TopdataTopFinderProSW6\Component\BreadcrumbsTrait;

class TopfinderPage extends Page
{
    use BreadcrumbsTrait;

    public $deviceHistory;

    protected $deviceList;

    /**
     * @var DeviceEntity
     */
    protected $device;

    /**
     * @var string
     */
    protected $pageTitle;

    /**
     * @deprecated tag:v6.3.0 use self::listing instead
     *
     * @var StorefrontSearchResult
     */
    protected $searchResult;

    /**
     * @var string
     */
    protected $searchTerm;

    /**
     * @var ProductListingResult
     */
    protected $listing;

    /**
     * [
     *     [
     *     'translated'=>[
     *       'name'=>$name
     *     ],
     *     'link'=>$url
     *   ]
     * ]
     * @var array
     */
    protected $path = [];

    /**
     * @deprecated tag:v6.3.0 use self::getListing instead
     */
    public function getSearchResult(): StorefrontSearchResult
    {
        return $this->searchResult;
    }

    /**
     * @deprecated tag:v6.3.0 use self::setListing instead
     */
    public function setSearchResult(StorefrontSearchResult $searchResult): void
    {
        $this->searchResult = $searchResult;
    }

    public function getSearchTerm(): string
    {
        return $this->searchTerm;
    }

    public function setSearchTerm(string $searchTerm): void
    {
        $this->searchTerm = $searchTerm;
    }

    public function getListing(): ProductListingResult
    {
        return $this->listing;
    }

    public function setListing(ProductListingResult $listing): void
    {
        $this->listing = $listing;
    }

    public function getPageTitle(): string
    {
        return $this->pageTitle;
    }

    public function setPageTitle(string $pageTitle): void
    {
        $this->pageTitle = $pageTitle;
    }

    public function getDevice(): DeviceEntity
    {
        return $this->device;
    }

    public function setDevice(DeviceEntity $device): void
    {
        $this->device = $device;
    }

    public function setDeviceList(array $deviceList): void
    {
        $this->deviceList = $deviceList;
    }

    public function getDeviceList(): array
    {
        return $this->deviceList;
    }
}
