<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\CompatibleDevicesWidget;

use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Storefront\Page\Page;

/**
 * This class represents the Compatible Devices Widget, extending the base Storefront Page.
 * It handles the logic and data required to display compatible devices for a product.
 */
class CompatibleDevicesWidgetPageV2 extends Page
{

    protected array $devices = [];
    public $brandName;
    public $groupMode;
    public $deviceNameMode;
    public $uniqueSeries       = [];
    public $uniqueTypes        = [];
    public $noTypeDevicesCount = 0;
    public $deviceList         = [];
    public SalesChannelProductEntity $product;

    /**
     * Returns the array of devices.
     *
     * @return array
     */
    public function getDevices(): array
    {
        return $this->devices;
    }

    /**
     * Sets the array of devices and processes them to extract unique series and types.
     *
     * @param array $devices
     */
    public function setDevices(array $devices): void
    {
        $this->devices = $devices;
        // ---- Iterate through each device to extract unique series and types
        foreach ($devices as $device) {
            // ---- Check if the device has a series ID and if it's not already in the unique series array
            if ($device['series_id'] && !isset($this->uniqueSeries[$device['series_id']])) {
                $this->uniqueSeries[$device['series_id']] = $device['series_name'];
            }
            // ---- Check if the device has a type ID and if it's not already in the unique types array
            if ($device['type_id'] && !isset($this->uniqueTypes[$device['type_id']])) {
                $this->uniqueTypes[$device['type_id']] = $device['type_name'];
            } elseif (!$device['type_id']) {
                // ---- Increment the count of devices without a type ID
                $this->noTypeDevicesCount++;
            }
            $this->uniqueTypes = array_unique($this->uniqueTypes);
            sort($this->uniqueTypes, SORT_LOCALE_STRING);
        }
    }
}