<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\DeviceSearch;

use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Shopware\Storefront\Page\Page;

class DeviceSearchPage extends Page
{
    protected EntitySearchResult $devices;
    protected int $totalSearchResult;
    protected string $deviceSearchTerm;
    protected int $compactModeLimit = 10;
    public int $offset = 0;
    public array $deviceListDevices = [];
    public int $limit = 500;

    public function getDevices(): EntitySearchResult
    {
        return $this->devices;
    }

    public function setDevices(EntitySearchResult $devices): void
    {
        $this->devices = $devices;
    }

    public function getTotalSearchResult(): int
    {
        return $this->totalSearchResult;
    }

    public function setTotalSearchResult(int $totalSearchResult): void
    {
        $this->totalSearchResult = $totalSearchResult;
    }

    public function getDeviceSearchTerm(): string
    {
        return $this->deviceSearchTerm;
    }

    public function setDeviceSearchTerm(string $searchTerm): void
    {
        $this->deviceSearchTerm = $searchTerm;
    }

    public function getCompactModeLimit(): int
    {
        return $this->compactModeLimit;
    }

    public function setCompactModeLimit(int $value): void
    {
        $this->compactModeLimit = $value;
    }
}
