<?php

namespace Topdata\TopdataTopFinderProSW6\FoundationHotfix\Util;


use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * 04/2025 created
 */
class UtilJsonResponse
{
    /**
     * @param mixed $payload
     */
    public static function error(string $message, int $httpCode = Response::HTTP_INTERNAL_SERVER_ERROR, $payload = null): JsonResponse
    {
        return new JsonResponse([
            'success' => false,
            'message' => $message,
            'payload' => $payload
        ], $httpCode);
    }

    /**
     * @param mixed $payload
     */
    public static function success(?string $message = null, $payload = null): JsonResponse
    {
        return new JsonResponse([
            'success' => true,
            'message' => $message,
            'payload' => $payload
        ]);
    }

    /**
     * @param mixed $payload
     */
    public static function payload($payload, ?string $message = null): JsonResponse
    {
        return new JsonResponse([
            'success' => true,
            'message' => $message,
            'payload' => $payload
        ]);
    }
}