<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts\ListProductsPage;

/**
 * This event is dispatched after the ListProducts page has been loaded.
 * It allows to access and modify the page data.
 * TODO: rename to ListProductsPageLoadedEvent
 */
class ListProductsLoadedEvent extends PageLoadedEvent
{
    /**
     * @var ListProductsPage
     */
    protected $page;

    public function __construct(ListProductsPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    /**
     * Returns the ListProducts page.
     *
     * @return ListProductsPage
     */
    public function getPage(): ListProductsPage
    {
        return $this->page;
    }
}