<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Controller;

use Shopware\Core\Checkout\Cart\Exception\CustomerNotLoggedInException;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\Uuid\Uuid;
use Shopware\Core\Framework\Validation\DataBag\RequestDataBag;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Controller\StorefrontController;
use Shopware\Storefront\Page\Page;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Routing\Annotation\Route;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceEntity;
use Topdata\TopdataTopFinderProSW6\FoundationHack\Util\UtilUuid;
use Topdata\TopdataTopFinderProSW6\Component\Collection;
use Topdata\TopdataTopFinderProSW6\Constants\CookieKeyNameConstants;
use Topdata\TopdataTopFinderProSW6\Constants\TopfinderPluginConstants;
use Topdata\TopdataTopFinderProSW6\Service\TopdataDeviceDataService;
use Topdata\TopdataTopFinderProSW6\Service\DeviceHistoryService_Cookie;
use Topdata\TopdataTopFinderProSW6\Service\DeviceToCustomerService;
use Topdata\TopdataTopFinderProSW6\Service\SettingsService;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Device\DevicePage;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\BrandLetterPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\DevicePageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\ListProductsPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\PopupDeviceInfoWidgetPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\PopupDeviceWidgetPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\PopupFormWidgetPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\DeviceListPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\DeviceSearchPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\DeviceSuggestPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\MyList\BrandsListPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\MyList\TypeListPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\Popup\PopupSearchPageLoader;
use Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder\Popup\SeriesListPageLoader;
use Topdata\TopdataTopFinderProSW6\Util\ControllerUtil;

/**
 * 04/2025 created (extracted from TopFinderController)
 * @\Symfony\Component\Routing\Annotation\Route(defaults={"_routeScope"={"storefront"}})

 */
class TopFinderDeviceController extends StorefrontController
{
    /**
     * @readonly
     */
    private EntityRepository $topdataBrandRepository;
    /**
     * @readonly
     */
    private EntityRepository $topdataDeviceRepository;
    /**
     * @readonly
     */
    private EntityRepository $topdataSeriesRepository;
    /**
     * @readonly
     */
    private EntityRepository $topdataDeviceTypeRepository;
    /**
     * @readonly
     */
    private SettingsService $settingsService;
    /**
     * @readonly
     */
    private DevicePageLoader $devicePageLoader;
    /**
     * @readonly
     */
    private TopdataDeviceDataService $deviceDataService;
    /**
     * @readonly
     */
    private DeviceToCustomerService $deviceToCustomerService;
    /**
     * @readonly
     */
    private DeviceHistoryService_Cookie $deviceHistoryService_Cookie;
    const DEVICE_HISTORY_COOKIE_TTL = 3600 * 24 * 30;
    public function __construct(EntityRepository            $topdataBrandRepository, EntityRepository            $topdataDeviceRepository, EntityRepository            $topdataSeriesRepository, EntityRepository            $topdataDeviceTypeRepository, SettingsService             $settingsService, DevicePageLoader            $devicePageLoader, TopdataDeviceDataService    $deviceDataService, DeviceToCustomerService     $deviceToCustomerService, DeviceHistoryService_Cookie $deviceHistoryService_Cookie)
    {
        $this->topdataBrandRepository = $topdataBrandRepository;
        $this->topdataDeviceRepository = $topdataDeviceRepository;
        $this->topdataSeriesRepository = $topdataSeriesRepository;
        $this->topdataDeviceTypeRepository = $topdataDeviceTypeRepository;
        $this->settingsService = $settingsService;
        $this->devicePageLoader = $devicePageLoader;
        $this->deviceDataService = $deviceDataService;
        $this->deviceToCustomerService = $deviceToCustomerService;
        $this->deviceHistoryService_Cookie = $deviceHistoryService_Cookie;
    }
    /**
     * Handles the request to get a device page.
     *
     * This method is responsible for loading the device page based on the provided device code.
     * It checks if the device is in the device list, sets the device history if applicable,
     * fills select boxes with relevant data, and renders the device page.
     *
     * @param Request $request The HTTP request object.
     * @param SalesChannelContext $salesChannelContext The sales channel context.
     * @return Response The HTTP response object containing the rendered device page.
     * @\Symfony\Component\Routing\Annotation\Route(path="/top-finder/device/{deviceCode}", name="frontend.top-finder.device", defaults={"XmlHttpRequest": true}, methods={"GET", "POST"})
     */
    public function devicePageAction(Request $request, SalesChannelContext $salesChannelContext): Response
    {
        return $this->_renderDevicePage($request, $salesChannelContext);
    }
    /**
     * @\Symfony\Component\Routing\Annotation\Route(path="/top-finder/device/{deviceCode}/{propertyGroupOptionId}", name="frontend.top-finder.device_tab", defaults={"XmlHttpRequest": true}, methods={"GET", "POST"})
     */
    public function getDeviceTabAction(Request $request, SalesChannelContext $salesChannelContext): Response
    {
        return $this->_renderDevicePage($request, $salesChannelContext);
    }
    /**
     * Adds the current device to the device history.
     */
    private function _addDeviceToHistoryCookie(Request $request, DevicePage $devicePage): void
    {
        $devicePage->deviceHistory = $this->deviceHistoryService_Cookie->getAndUpdateDeviceHistory($request, $devicePage->getDeviceId());
    }
    /**
     * Fills the select boxes on the device page with relevant data.
     *
     * This method populates the select boxes on the device page with data such as brand, series, type, and device history.
     * It retrieves the necessary data from the repositories and sets the appropriate values in the finder structure.
     *
     * @param Page $page The page object containing the header and other page data.
     * @param DeviceEntity $device The device entity containing the device details.
     * @param SalesChannelContext $salesChannelContext The sales channel context.
     * @param Request $request The HTTP request object.
     * @return void
     */
    private function _fillSelectboxes(Page $page, DeviceEntity $device, SalesChannelContext $salesChannelContext, Request $request): void
    {
        $finderStruct = $page->getHeader()->getExtension('finder');
        if ($finderStruct === null) {
            $finderStruct = new Collection();
        }

        if ($device->getBrandId()) {
            $brand = $this
                ->topdataBrandRepository
                ->search(
                    (new Criteria([$device->getBrandId()]))
                        ->addFilter(new EqualsFilter('enabled', true)),
                    $salesChannelContext->getContext()
                )
                ->getEntities()
                ->first();
            if ($brand) {
                $finderStruct->set('brandCode', $brand->getCode());
            }
        }

        if ($device->getSeriesId()) {
            $series = $this
                ->topdataSeriesRepository
                ->search(
                    (new Criteria([$device->getSeriesId()]))
                        ->addFilter(new EqualsFilter('enabled', true)),
                    $salesChannelContext->getContext()
                )
                ->getEntities()
                ->first();
            if ($series) {
                $finderStruct->set('seriesCode', $series->getCode());
            }
        }

        if ($device->getTypeId()) {
            $type = $this
                ->topdataDeviceTypeRepository
                ->search(
                    (new Criteria([$device->getTypeId()]))
                        ->addFilter(new EqualsFilter('enabled', true)),
                    $salesChannelContext->getContext()
                )
                ->getEntities()
                ->first();
            if ($type) {
                $finderStruct->set('typeCode', $type->getCode());
            }
        }

        $finderStruct->set('deviceCode', $device->getCode());

        if (is_array($page->deviceHistory) && count($page->deviceHistory)
            && ($this->settingsService->getBool('showDevicesSlider')
                || $this->settingsService->getBool('showDeviceHistorySelect'))
        ) {
            $criteria = (new Criteria(array_reverse($page->deviceHistory)))
                ->addFilter(new EqualsFilter('enabled', true))
                ->addAssociations(['brand', 'media']);
            $devicesHistory = $this->topdataDeviceRepository->search($criteria, $salesChannelContext->getContext())->getElements();
            foreach ($devicesHistory as $dev) {
                if ($this->settingsService->getBool('showDevicelist')) {
                    $dev->setInDeviceList(
                        in_array(
                            $dev->getId(),
                            $this->deviceToCustomerService->getCustomerDeviceIds($salesChannelContext)
                        )
                    );
                } else {
                    $dev->setInDeviceList(false);
                }
            }
            $devicesHistoryStruct = new Collection();
            $devicesHistoryStruct->set('devices', $devicesHistory);
            if ($this->settingsService->getBool('showDeviceHistorySelect')) {
                $page->getHeader()->removeExtension('deviceHistory');
                $page->getHeader()->addExtension('deviceHistory', $devicesHistoryStruct);
            }
            if ($this->settingsService->getBool('showDevicesSlider')) {
                $devicesHistoryStruct->set('userHiddable', $this->settingsService->getBool('deviceSliderUserHide'));
                $devicesHistoryStruct->set('hidden', $request->cookies->get(CookieKeyNameConstants::DEVICE_SLIDER) === 'hidden');

                $page->getHeader()->removeExtension('deviceSlider');
                $page->getHeader()->addExtension('deviceSlider', $devicesHistoryStruct);
            }
        }

        if ($this->settingsService->getConfig('showSeries')) {
            $series = ControllerUtil::getEntityCollection(
                $this->topdataSeriesRepository,
                [
                    'enabled' => true,
                    'brandId' => $device->getBrandId(),
                ],
                'label'
            );
            $finderStruct->set('series', $series);
        }

        if ($this->settingsService->getConfig('showTypes')) {
            $types = ControllerUtil::getEntityCollection(
                $this->topdataDeviceTypeRepository,
                [
                    'enabled' => true,
                    'brandId' => $device->getBrandId(),
                ],
                'label'
            );
            $finderStruct->set('types', $types);
        }
        $devices = $this->deviceDataService->getFilteredDevices($device->getBrandId(), $device->getSeriesId(), $device->getTypeId(), false);
        //        $devices = $this->getEntityCollection($this->topdataDeviceRepository, $deviceParams, 'model', false);
        $finderStruct->set('devices', $devices);

        //        $finderStruct->set('test', true);
        //        $page->getHeader()->removeExtension('finder');
        //        $page->getHeader()->addExtension('finder', $finderStruct);
    }
    public function _setDeviceHistoryCookie(Response $response, DevicePage $devicePage): void
    {
        $response->headers->setCookie(
            Cookie::create(
                CookieKeyNameConstants::DEVICE_HISTORY,
                implode(',', $devicePage->deviceHistory),
                time() + self::DEVICE_HISTORY_COOKIE_TTL
            )
        );
    }
    /**
     * 04/2025 created (extracted from showDevicePageAction)
     */
    private function _renderDevicePage(Request $request, SalesChannelContext $salesChannelContext): Response
    {
        $devicePage = $this->devicePageLoader->loadDevicePageData($salesChannelContext);
        $deviceId = $devicePage->getDeviceId();
        $deviceEntity = $devicePage->getDevice();

        $isInCustomersDeviceList = in_array($deviceId, $this->deviceToCustomerService->getCustomerDeviceIds($salesChannelContext));
        $deviceEntity->setInDeviceList($isInCustomersDeviceList);

        if ($request->isXmlHttpRequest() === false
            && $this->settingsService->getBool('showDeviceHistory')) {
            $this->_addDeviceToHistoryCookie($request, $devicePage);
        }

        if ($request->isXmlHttpRequest() === false) {
            $this->_fillSelectboxes($devicePage, $deviceEntity, $salesChannelContext, $request);
        }
        $response = $this->renderStorefront('@TopdataTopFinderProSW6/storefront/page/topfinder/device-page.html.twig', ['page' => $devicePage]);

        if ($request->isXmlHttpRequest() === false) {
            if ($this->settingsService->getBool('showDeviceHistory')) {
                $this->_setDeviceHistoryCookie($response, $devicePage);
            }
        }

        return $response;
    }
}
