<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Storefront\Page\CompatibleDevicesWidget;

use Shopware\Storefront\Page\Page;

/**
 * 04/2025 FIXME: this is code duplication with CompatibleDevicesWidgetPage from TopdataTopFinderProSW6
 */
class CompatibleDevicesWidgetPageV1 extends Page
{
    protected array $devices = [];
    public array $uniqueSeries = [];
    public array $uniqueTypes = [];
    public ?\Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity $product = null;
    public int $noTypeDevicesCount = 0;
    
    public function getDevices() : array
    {
        return $this->devices;
    }
    
    public function setDevices(array $devices): void
    {
        $this->devices = $devices;
        foreach ($devices as $device) {
            if($device['series_id'] && !isset($this->uniqueSeries[$device['series_id']])) {
                $this->uniqueSeries[$device['series_id']] = $device['series_name'];
            }
            if($device['type_id'] && !isset($this->uniqueTypes[$device['type_id']])) {
                $this->uniqueTypes[$device['type_id']] = $device['type_name'];
            }
            elseif(!$device['type_id']) {
                $this->noTypeDevicesCount++;
            }
            $this->uniqueTypes = array_unique($this->uniqueTypes);
            sort($this->uniqueTypes, SORT_LOCALE_STRING);
        }
    }
}
