# Topdata TopFeed for Shopware 6

## Description
Topdata TopFeed is a Shopware 6 plugin that enables automatic synchronization of product data between your Shopware store and TopData's cloud-based web service. This plugin enhances your product pages with rich, up-to-date information and improves cross-selling capabilities.

## Features
- Automatic product data synchronization (name, description, brand, EAN, MPN, images, specifications)
- Enhanced product relationships (variants, alternates, bundles, accessories)
- Compatible devices display
- Customizable product detail page with additional tabs and information
- Configurable cross-selling features
- Support for color and capacity variants

## Requirements
- **Shopware 6.7** (minimum requirement)
- PHP 8.1 or higher
- TopData Connector for Shopware 6 (version 8.0.0 or later)
- TopData Foundation for Shopware 6 (version 1.0 or later)

## Installation
1. Install the TopData Connector for Shopware 6 if you haven't already.
2. Upload the plugin files to your Shopware installation's `custom/plugins` directory.
3. Install and activate the plugin through the Shopware Administration panel.

## Configuration
After installation, you can configure the plugin in the Shopware Administration panel under Settings > System > Plugins > Topdata TopFeed.

Configuration options include:
- Import settings for various product data types
- Display settings for product detail pages
- Cross-selling options
- Product menu and list display options

## Usage
Once configured, the plugin will automatically sync product data from TopData's service. The enhanced product information and relationships will be visible on your store's product pages.

## Release Notes - Version 1.0.0 (SW 6.7 Migration)

### What's New
- **Full Shopware 6.7 Compatibility**: Complete migration to support Shopware 6.7
- **Enhanced Admin Interface**: Updated admin components to use new Shopware 6.7 UI framework
- **Improved Backend Services**: Refactored helper services for better performance and maintainability
- **Code Quality Improvements**: Added native type declarations and improved code structure

### Migration Changes
- **Admin Components**: Migrated from legacy template overrides to programmatic component extensions using `<mt-tabs>`
- **Backend Services**: Updated all services to use `TopfeedHelperServiceV2` for improved data handling
- **Storefront Templates**: Cleaned up deprecated modal popup code and streamlined template structure
- **Dependencies**: Updated to require Shopware 6.7.* and PHP 8.1+

### Breaking Changes
- **Minimum Requirements**: Now requires Shopware 6.7 or higher
- **PHP Version**: Minimum PHP version increased to 8.1
- **Connector Version**: Requires TopData Connector version 8.0.0 or later

### Upgrade Instructions
1. Ensure your Shopware installation is updated to version 6.7
2. Update PHP to version 8.1 or higher
3. Update TopData Connector to version 8.0.0 or later
4. Install the new TopData Foundation plugin (version 1.0 or later)
5. Upload and activate the updated TopFeed plugin
6. Clear cache and rebuild storefront assets

## Support
For support and more information, please visit: https://www.topdata.de/topfeed

## About TopData
TopData Software GmbH specializes in providing comprehensive product data solutions for e-commerce platforms. Visit [www.topdata.de](https://www.topdata.de) for more information about our services.

## License
This plugin is released under the MIT License. See the LICENSE file for more details.
