<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Storefront\Page\LinkedProductsPopup;

use Doctrine\DBAL\Connection;
use Topdata\TopdataTopFeedSW6\Service\TopfeedHelperServiceV1;
use Topdata\TopdataTopFeedSW6\Service\SettingsService;

/**
 * 10/2024 created
 */
class ProductIdRetriever
{

    public function __construct(
        private readonly SettingsService      $settingsService,
        private readonly TopfeedHelperServiceV1 $topfeedHelperServiceV1,
    )
    {
    }

//    /**
//     * 10/2024 the original version before getting merged with getLinkedProductIdsByLinkType
//     */
//    public function getProductIds(LinkTypeEnum $pageType, string $productId, ?string $parentId): array
//    {
//        return match ($pageType) {
//            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperServiceV1->getAlternateProductIds($productId, $parentId),
//            LinkTypeEnum::BUNDLED           => $this->topfeedHelperServiceV1->getBundledProductIds($productId, $parentId),
//            LinkTypeEnum::BUNDLES           => $this->topfeedHelperServiceV1->getBundleIds($productId, $parentId),
//            LinkTypeEnum::RELATED           => $this->topfeedHelperServiceV1->getRelatedProductIds($productId, $parentId),
//            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperServiceV1->getColorVariantProductIds($productId, $parentId),
//            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperServiceV1->getCapacityVariantProductIds($productId, $parentId),
//            LinkTypeEnum::VARIANTS          => $this->topfeedHelperServiceV1->getVariantProductIds($productId, $parentId),
//            LinkTypeEnum::SIMILAR           => $this->topfeedHelperServiceV1->getSimilarProductIds($productId, $parentId),
//            default                         => [],
//        };
//    }
//
//
//    /**
//     * 10/2024 the original version before getting merged with getProductIds
//     * FIXME: it is same like getProductIds, but it is used in TopdataTopFeedApiController?
//     *
//     * 10/2024 moved from TopdataTopFeedApiController to here
//     *
//     * Retrieves linked product IDs based on the link type and main product ID.
//     *
//     * This private method is used internally to fetch the IDs of linked products
//     * for a specific link type (e.g., variants, alternates, bundles) and main product.
//     *
//     * @param LinkTypeEnum $linkTypeEnum The type of link
//     * @param string $mainProductId The ID of the main product
//     * @return array An array of linked product IDs
//     */
//    public function getLinkedProductIdsByLinkType(LinkTypeEnum $linkTypeEnum, string $mainProductId): array
//    {
//        return match ($linkTypeEnum) {
//            LinkTypeEnum::VARIANTS          => $this->topfeedHelperServiceV1->getVariantProductIds($mainProductId),
//            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperServiceV1->getColorVariantProductIds($mainProductId),
//            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperServiceV1->getCapacityVariantProductIds($mainProductId),
//            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperServiceV1->getAlternateProductIds($mainProductId),
//            LinkTypeEnum::BUNDLED           => $this->topfeedHelperServiceV1->getBundledProductIds($mainProductId),
//            LinkTypeEnum::BUNDLES           => $this->topfeedHelperServiceV1->getBundleIds($mainProductId),
//            LinkTypeEnum::RELATED           => $this->topfeedHelperServiceV1->getRelatedProductIds($mainProductId),
//            default                         => [],
//        };
//    }

    /**
     * 10/2024 created
     */
    public function getLinkedProductIdsByLinkType(LinkTypeEnum $linkType, string $productId, ?string $parentId = null): array
    {
        return match ($linkType) {
            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperServiceV1->getAlternateProductIds($productId, $parentId),
            LinkTypeEnum::BUNDLED           => $this->topfeedHelperServiceV1->getBundledProductIds($productId, $parentId),
            LinkTypeEnum::BUNDLES           => $this->topfeedHelperServiceV1->getBundleIds($productId, $parentId),
            LinkTypeEnum::RELATED           => $this->topfeedHelperServiceV1->getRelatedProductIds($productId, $parentId),
            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperServiceV1->getColorVariantProductIds($productId, $parentId),
            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperServiceV1->getCapacityVariantProductIds($productId, $parentId),
            LinkTypeEnum::VARIANTS          => $this->topfeedHelperServiceV1->getVariantProductIds($productId, $parentId),
            LinkTypeEnum::SIMILAR           => $this->topfeedHelperServiceV1->getSimilarProductIds($productId, $parentId),
            default                         => [],
        };
    }

    /**
     * 10/2024 created (extracted from TopFeedApiController)
     */
    public function getProductIdsUsingSettings(LinkTypeEnum $linkType, string $productId): array
    {
        return match ($linkType) {
            LinkTypeEnum::VARIANTS          => $this->settingsService->getBool('listVariantProducts') ? $this->topfeedHelperServiceV1->getVariantProductIds($productId) : [],
            LinkTypeEnum::COLOR_VARIANTS    => $this->settingsService->getBool('listColorVariantProducts') ? $this->topfeedHelperServiceV1->getColorVariantProductIds($productId) : [],
            LinkTypeEnum::CAPACITY_VARIANTS => $this->settingsService->getBool('listCapacityVariantProducts') ? $this->topfeedHelperServiceV1->getCapacityVariantProductIds($productId) : [],
            LinkTypeEnum::ALTERNATE         => $this->settingsService->getBool('listAlternateProducts') ? $this->topfeedHelperServiceV1->getAlternateProductIds($productId) : [],
            LinkTypeEnum::BUNDLED           => $this->settingsService->getBool('listBundledProducts') ? $this->topfeedHelperServiceV1->getBundledProductIds($productId) : [],
            LinkTypeEnum::BUNDLES           => $this->settingsService->getBool('listBundles') ? $this->topfeedHelperServiceV1->getBundleIds($productId) : [],
            LinkTypeEnum::RELATED           => $this->settingsService->getBool('listRelatedProducts') ? $this->topfeedHelperServiceV1->getRelatedProductIds($productId) : [],
            default                         => [],
        };
    }


}
