<?php

namespace Topdata\TopdataTopFeedSW6\Service;

use Shopware\Core\Framework\Struct\ArrayStruct;
use Shopware\Core\Framework\Struct\ExtendableInterface;

/**
 * for extending pages, but could be used for other things too
 *
 * 10/2024 created
 */
class PageExtensionService
{
    private string $extensionName; // eg 'TopdataTopFeedSW6';
    private ExtendableInterface $page;

    /**
     * 10/2024 created
     */
    public function init(string $extensionName, ExtendableInterface $page): void
    {
        $this->extensionName = $extensionName;
        $this->page = $page;
    }

    /**
     * Get or create an extension on a page.
     *
     * @param ExtendableInterface $this->page
     * @return ArrayStruct
     */
    public function getOrCreateExtension(): ArrayStruct
    {
        $extension = $this->page->getExtension($this->extensionName);

        if ($extension === null) {
            $extension = new ArrayStruct();
            $this->page->addExtension($this->extensionName, $extension);
        }

        return $extension;
    }

    /**
     * Add or update data in an extension.
     *
     * @param ExtendableInterface $this->page
     * @param array $data
     * @return ArrayStruct
     */
    public function updateExtension(array $data): ArrayStruct
    {
        $extension = $this->getOrCreateExtension();
        $extension->assign($data);

        return $extension;
    }

    /**
     * Get a value from an extension, with a default if not set.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function getExtensionValue(string $key, $default = null)
    {
        $extension = $this->page->getExtension($this->extensionName);

        if ($extension === null || !$extension->has($key)) {
            return $default;
        }

        return $extension->get($key);
    }
}