<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Subscriber;

use Shopware\Storefront\Page\Product\ProductPageLoadedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Topdata\TopdataTopFeedSW6\Service\ProductPageExtender;

/**
 * Class ProductPageLoadedEventSubscriber
 *
 * This subscriber handles the ProductPageLoadedEvent to add additional product information
 * such as associated products, variants, and devices to the product page.
 */
class ProductPageLoadedEventSubscriber implements EventSubscriberInterface
{


    public function __construct(
        private readonly ProductPageExtender    $productPageExtender,
    )
    {
    }

    /**
     * Returns an array of events this subscriber wants to listen to.
     *
     * @return array
     */
    public static function getSubscribedEvents(): array
    {
        return [
            ProductPageLoadedEvent::class => 'handleProductPageLoadedEvent',
        ];
    }

    /**
     * ==== MAIN ====
     *
     * Handles the ProductPageLoadedEvent by adding additional product information.
     *
     * @param ProductPageLoadedEvent $event
     */
    public function handleProductPageLoadedEvent(ProductPageLoadedEvent $event): void
    {
        $this->productPageExtender->init($event->getPage(), $event->getSalesChannelContext());
        $this->productPageExtender->addAssociatedProducts();
        $this->productPageExtender->addProductVariants();
        $this->productPageExtender->addProductHasDevices();
        $this->productPageExtender->addProductVariantOtherDevices();
    }


}
