import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import HttpClient from 'src/service/http-client.service';

/**
 * TopdataTopFeedProductDetailTab is a custom plugin that handles the product detail configurator select functionality.
 * It listens for changes on a specified item selector and redirects the user to a URL based on the selected option.
 */
export default class TopdataTopFeedProductDetailTab extends Plugin {
    /**
     * Default options for the plugin.
     * @type {Object}
     * @property {string} itemSelector - The CSS selector for the item to attach the event listener to.
     */
    static options = {
        /**
         * Selector of Item
         *
         * @type string
         */
        itemSelector: '.topdata-top-feed-product-select',
    };

    /**
     * Initializes the plugin by setting up the HTTP client and adding the event listener.
     */
    init() {
        this._client = new HttpClient();
        let TopFeedProductDetailTabElement = DomAccess.querySelector(document, this.options.itemSelector);
        TopFeedProductDetailTabElement.addEventListener('change', this.openLink.bind(this));
    }

    /**
     * Event handler for the 'change' event on the item selector.
     * Prevents the default action and redirects the user to the URL specified in the selected option.
     *
     * @param {Event} event - The event object.
     */
    openLink(event) {
        event.preventDefault();

        //var path = DomAccess.querySelector(document, this.options.itemSelector).dataset.path;
        let container = DomAccess.querySelector(document, this.options.itemSelector);
        let url = container.options[container.selectedIndex].value;
        //console.log(container.selectedIndex);
        //console.log(container.options[container.selectedIndex].value);

        if(url === '') {
            return;
        }
        window.location.href = url;
    }
}