<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Topdata\TopdataFoundationSW6\DependencyInjection\TopConfigServiceCompilerPass;

class TopdataTopFeedSW6 extends Plugin
{

    private const MAPPINGS = [
        'productName'                    => 'import.product.name',
        'productDescription'             => 'import.product.description',
        'productBrand'                   => 'import.product.brand',
        'productEan'                     => 'import.product.ean',
        'productOem'                     => 'import.product.mpn',
        'productImages'                  => 'import.product.images.enabled',
        'productImagesDelete'            => 'import.product.images.deleteUnused', // UNUSED
        'productSpecifications'          => 'import.product.specifications',
        'specReferencePCD'               => 'import.product.references.pcd',
        'specReferenceOEM'               => 'import.product.references.oem',
        'productWaregroups'              => 'import.categories.enabled',
        'productWaregroupsDelete'        => 'import.categories.clearBeforeImport',
        'productWaregroupsParent'        => 'import.categories.parentId',
        'productSimilar'                 => 'crossSelling.similar.import',
        'productSimilarCross'            => 'crossSelling.similar.enabled',
        'productAlternate'               => 'crossSelling.alternate.import',
        'productAlternateCross'          => 'crossSelling.alternate.enabled',
        'productRelated'                 => 'crossSelling.related.import',
        'productRelatedCross'            => 'crossSelling.related.enabled',
        'productBundled'                 => 'crossSelling.bundled.import',
        'productBundledCross'            => 'crossSelling.bundled.enabled',
        'productVariant'                 => 'crossSelling.variant.import',
        'productVariantCross'            => 'crossSelling.variant.enabled',
        'productVariantColor'            => 'crossSelling.variantColor.import',
        'productVariantColorCross'       => 'crossSelling.variantColor.enabled',
        'productVariantCapacity'         => 'crossSelling.variantCapacity.import',
        'productVariantCapacityCross'    => 'crossSelling.variantCapacity.enabled',
        'colorVariants'                  => 'detail.variants.color.display',
        'capacityVariants'               => 'detail.variants.capacity.display',
        'variantsHideForVariated'        => 'detail.variants.hideForVariated',
        'showProductDevicesTab'          => 'detail.tabs.compatibleDevices',
        'showVariantProductsTab'         => 'detail.tabs.variants',
        'showColorVariantProductsTab'    => 'detail.tabs.variantColors',
        'showCapacityVariantProductsTab' => 'detail.tabs.variantCapacities',
        'showAlternateProductsTab'       => 'detail.tabs.alternateProducts',
        'showBundledProductsTab'         => 'detail.tabs.bundledProducts',
        'showBundlesTab'                 => 'detail.tabs.bundles',
        'showRelatedProductsTab'         => 'detail.tabs.relatedProducts',
        'showSimilarProductsTab'         => 'detail.tabs.similarProducts',
        'showVariantProducts'            => 'menu.variants',
        'showColorVariantProducts'       => 'menu.variantColors',
        'showCapacityVariantProducts'    => 'menu.variantCapacities',
        'showAlternateProducts'          => 'menu.alternateProducts',
        'showBundledProducts'            => 'menu.bundledProducts',
        'showBundles'                    => 'menu.bundles',
        'showRelatedProducts'            => 'menu.relatedProducts',
        'showSimilarProducts'            => 'menu.similarProducts',
        'menuHideForVariated'            => 'menu.hideForVariated',
        'listVariantsLimit'              => 'list.variantsLimit',
        'listVariantProducts'            => 'list.variants',
        'listColorVariantProducts'       => 'list.variantColors',
        'listCapacityVariantProducts'    => 'list.variantCapacities',
        'listAlternateProducts'          => 'list.alternateProducts',
        'listBundledProducts'            => 'list.bundledProducts',
        'listBundles'                    => 'list.bundles',
        'listRelatedProducts'            => 'list.relatedProducts',
        'listHideForVariated'            => 'list.hideForVariated'
    ];

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        // ---- register the plugin in Topdata Configration Center's TopConfigService
        if(class_exists(TopConfigServiceCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigServiceCompilerPass(__CLASS__, self::MAPPINGS));
        }
    }
    
    
    public function uninstall(UninstallContext $context): void
    {
        parent::uninstall($context);

        if ($context->keepUserData()) {
            return;
        }
        
    }
    
}