<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Storefront\Page\LinkedProductsPopup;

use Doctrine\DBAL\Connection;
use Topdata\TopdataTopFeedSW6\Service\TopfeedHelperService;
use Topdata\TopdataTopFeedSW6\Service\SettingsService;

/**
 * 10/2024 created
 */
class ProductIdRetriever
{

    public function __construct(
        private readonly SettingsService      $settingsService,
        private readonly TopfeedHelperService $topfeedHelperService,
    )
    {
    }

//    /**
//     * 10/2024 the original version before getting merged with getLinkedProductIdsByLinkType
//     */
//    public function getProductIds(LinkTypeEnum $pageType, string $productId, ?string $parentId): array
//    {
//        return match ($pageType) {
//            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperService->getAlternateProductIds($productId, $parentId),
//            LinkTypeEnum::BUNDLED           => $this->topfeedHelperService->getBundledProductIds($productId, $parentId),
//            LinkTypeEnum::BUNDLES           => $this->topfeedHelperService->getBundleIds($productId, $parentId),
//            LinkTypeEnum::RELATED           => $this->topfeedHelperService->getRelatedProductIds($productId, $parentId),
//            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperService->getColorVariantProductIds($productId, $parentId),
//            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperService->getCapacityVariantProductIds($productId, $parentId),
//            LinkTypeEnum::VARIANTS          => $this->topfeedHelperService->getVariantProductIds($productId, $parentId),
//            LinkTypeEnum::SIMILAR           => $this->topfeedHelperService->getSimilarProductIds($productId, $parentId),
//            default                         => [],
//        };
//    }
//
//
//    /**
//     * 10/2024 the original version before getting merged with getProductIds
//     * FIXME: it is same like getProductIds, but it is used in TopdataTopFeedApiController?
//     *
//     * 10/2024 moved from TopdataTopFeedApiController to here
//     *
//     * Retrieves linked product IDs based on the link type and main product ID.
//     *
//     * This private method is used internally to fetch the IDs of linked products
//     * for a specific link type (e.g., variants, alternates, bundles) and main product.
//     *
//     * @param LinkTypeEnum $linkTypeEnum The type of link
//     * @param string $mainProductId The ID of the main product
//     * @return array An array of linked product IDs
//     */
//    public function getLinkedProductIdsByLinkType(LinkTypeEnum $linkTypeEnum, string $mainProductId): array
//    {
//        return match ($linkTypeEnum) {
//            LinkTypeEnum::VARIANTS          => $this->topfeedHelperService->getVariantProductIds($mainProductId),
//            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperService->getColorVariantProductIds($mainProductId),
//            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperService->getCapacityVariantProductIds($mainProductId),
//            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperService->getAlternateProductIds($mainProductId),
//            LinkTypeEnum::BUNDLED           => $this->topfeedHelperService->getBundledProductIds($mainProductId),
//            LinkTypeEnum::BUNDLES           => $this->topfeedHelperService->getBundleIds($mainProductId),
//            LinkTypeEnum::RELATED           => $this->topfeedHelperService->getRelatedProductIds($mainProductId),
//            default                         => [],
//        };
//    }

    /**
     * 10/2024 created
     */
    public function getLinkedProductIdsByLinkType(LinkTypeEnum $linkType, string $productId, ?string $parentId = null): array
    {
        return match ($linkType) {
            LinkTypeEnum::ALTERNATE         => $this->topfeedHelperService->getAlternateProductIds($productId, $parentId),
            LinkTypeEnum::BUNDLED           => $this->topfeedHelperService->getBundledProductIds($productId, $parentId),
            LinkTypeEnum::BUNDLES           => $this->topfeedHelperService->getBundleIds($productId, $parentId),
            LinkTypeEnum::RELATED           => $this->topfeedHelperService->getRelatedProductIds($productId, $parentId),
            LinkTypeEnum::COLOR_VARIANTS    => $this->topfeedHelperService->getColorVariantProductIds($productId, $parentId),
            LinkTypeEnum::CAPACITY_VARIANTS => $this->topfeedHelperService->getCapacityVariantProductIds($productId, $parentId),
            LinkTypeEnum::VARIANTS          => $this->topfeedHelperService->getVariantProductIds($productId, $parentId),
            LinkTypeEnum::SIMILAR           => $this->topfeedHelperService->getSimilarProductIds($productId, $parentId),
            default                         => [],
        };
    }

    /**
     * 10/2024 created (extracted from TopFeedApiController)
     */
    public function getProductIdsUsingSettings(LinkTypeEnum $linkType, string $productId): array
    {
        return match ($linkType) {
            LinkTypeEnum::VARIANTS          => $this->settingsService->getBool('listVariantProducts') ? $this->topfeedHelperService->getVariantProductIds($productId) : [],
            LinkTypeEnum::COLOR_VARIANTS    => $this->settingsService->getBool('listColorVariantProducts') ? $this->topfeedHelperService->getColorVariantProductIds($productId) : [],
            LinkTypeEnum::CAPACITY_VARIANTS => $this->settingsService->getBool('listCapacityVariantProducts') ? $this->topfeedHelperService->getCapacityVariantProductIds($productId) : [],
            LinkTypeEnum::ALTERNATE         => $this->settingsService->getBool('listAlternateProducts') ? $this->topfeedHelperService->getAlternateProductIds($productId) : [],
            LinkTypeEnum::BUNDLED           => $this->settingsService->getBool('listBundledProducts') ? $this->topfeedHelperService->getBundledProductIds($productId) : [],
            LinkTypeEnum::BUNDLES           => $this->settingsService->getBool('listBundles') ? $this->topfeedHelperService->getBundleIds($productId) : [],
            LinkTypeEnum::RELATED           => $this->settingsService->getBool('listRelatedProducts') ? $this->topfeedHelperService->getRelatedProductIds($productId) : [],
            default                         => [],
        };
    }


}
