# TopFEED Configuration Guide

## Overview
TopFEED is a Shopware plugin for managing and displaying product data. This documentation describes the available configuration options.

## Plugin Information
- **Version**: 1.0.1
- **Compatibility**: Shopware 6.3.0.0 - 6.5.5.2
- **Support**: shopware@topdata.de

## Features
* High-quality product data from own maintenance
* Cross & upselling
* Article properties & specifications

## Configuration Options

### Basic Settings
1. **Sales Channel**
   - Select the sales channel for which the settings should apply

### Product Data Import
2. **Import Product Name**
   - Specify whether to use our defined product name or your own

3. **Import Product Description**
   - Specify whether to use our defined product description or your own

4. **Product Manufacturer**
   - Specify whether to use our defined product manufacturer or your own

5. **Import EANs**
   - Specify whether to import the article's EAN number

6. **Import OEMs**
   - Specify whether to import the article's OEM number

### Product Images
7. **Product Images**
   - Specify whether to use our product images or your own

8. **Delete Old Images**
   - Specify whether outdated product images should be deleted

### Product Properties
9. **Product Properties**
   - Specify whether to import our defined specifications
   - Examples: capacity, color, product type, etc.

10. **Reference PCDs as Properties**
    - Specify whether reference PCDs should be saved as properties

11. **Reference OEMs as Properties**
    - Specify whether reference OEMs should be saved as properties

### Categories
12. **Product Categories**
    - Specify whether to use our created product groups or your own

13. **Parent Category**
    - Set the main product group for the product categories

### Cross-Selling Options
14. **Similar Products**
    - Enable/disable import of similar products

15. **Alternative Products**
    - Enable/disable import of alternative products

16. **Related Products**
    - Enable/disable import of accessories

17. **Bundled Products**
    - Enable/disable import of product bundles

18. **Variants**
    - Enable/disable import of product variants

19. **Color Variants**
    - Enable/disable import of color variants

20. **Capacity Variants**
    - Enable/disable import of capacity variants

### Display Settings

#### Product Detail Page
21. **Other Colors - Display**
    - Configure the display of color variants

22. **Other Capacities - Display**
    - Configure the display of capacity variants

23. **Product Variants**
    - Enable/disable display of product variants

24. **Other Colors**
    - Enable/disable display of color variants

25. **Other Capacities**
    - Enable/disable display of capacity variants

26. **Alternative Products**
    - Enable/disable display of alternative products

27. **Products in Bundle**
    - Enable/disable display of bundle products

28. **Bundles with Product**
    - Enable/disable display of bundles containing the product

29. **Accessories**
    - Enable/disable display of accessories

30. **Similar Products**
    - Enable/disable display of similar products

#### Product Menu
31. **Product Variants**
    - Enable/disable variant display in menu

32. **Other Colors**
    - Enable/disable color variant display in menu

33. **Other Capacities**
    - Enable/disable capacity variant display in menu

34. **Alternative Products**
    - Enable/disable alternative product display in menu

35. **Products in Bundle**
    - Enable/disable bundle product display in menu

36. **Bundles with Product**
    - Enable/disable bundle display in menu

37. **Accessories**
    - Enable/disable accessories display in menu

38. **Similar Products**
    - Enable/disable similar product display in menu

#### Product List
39. **Product Variants**
    - Enable/disable variant display in list

40. **Other Colors**
    - Enable/disable color variant display in list

41. **Other Capacities**
    - Enable/disable capacity variant display in list

42. **Alternative Products**
    - Enable/disable alternative product display in list

43. **Products in Bundle**
    - Enable/disable bundle product display in list

44. **Bundles with Product**
    - Enable/disable bundle display in list

45. **Accessories**
    - Enable/disable accessories display in list

46. **Similar Products**
    - Enable/disable similar product display in list
