<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Service;

use Shopware\Core\System\SystemConfig\SystemConfigService;
use Topdata\TopdataTopFeedSW6\Storefront\Page\LinkedProductsPopup\LinkTypeEnum;

/**
 * LEGACY - will get replaced by the new TopConfigService
 */
class SettingsService
{
    private array $config; // the original config from SW6 native system config

    public function __construct(
        SystemConfigService $systemConfigService
    )
    {
        $this->config = $systemConfigService->get('TopdataTopFeedSW6.config');
    }

    /**
     * uses the old legacy keys
     */
    public function getBool(string $key): bool
    {
        return isset($this->config[$key]) ? (bool)$this->config[$key] : false;
    }

    /**
     * uses the old legacy keys
     */
    public function getString(string $key): string
    {
        return isset($this->config[$key]) ? (string)$this->config[$key] : '';
    }

    /**
     * uses the old legacy keys
     */
    public function getInt(string $key, bool $notNegative = false): int
    {
        $ret = isset($this->config[$key]) ? (int)$this->config[$key] : 0;

        if ($notNegative && ($ret < 0)) {
            return 0;
        }

        return $ret;
    }

    public function getConfig()
    {
        return $this->config;
    }

    /**
     * 10/2024 moved from TopFeedController to here
     *
     * Retrieves the settings for linked products.
     *
     * This private method is used internally to get the configuration settings
     * for different types of linked products (variants, alternates, bundles, etc.).
     *
     * @return array An associative array of linked product types and their enabled status
     */
    public function getLinkedSettings(): array
    {
        return [
            LinkTypeEnum::VARIANTS->value          => $this->getBool('listVariantProducts'),
            LinkTypeEnum::COLOR_VARIANTS->value    => $this->getBool('listColorVariantProducts'),
            LinkTypeEnum::CAPACITY_VARIANTS->value => $this->getBool('listCapacityVariantProducts'),
            LinkTypeEnum::ALTERNATE->value         => $this->getBool('listAlternateProducts'),
            LinkTypeEnum::BUNDLED->value           => $this->getBool('listBundledProducts'),
            LinkTypeEnum::BUNDLES->value           => $this->getBool('listBundles'),
            LinkTypeEnum::RELATED->value           => $this->getBool('listRelatedProducts'),
        ];
    }


    /**
     * just for debugging - these settings steuern die Tabs in der Produkt-Detailansicht
     * 10/2024 created
     */
    public function getTabsSettings(): array
    {
        return [
            LinkTypeEnum::ALTERNATE->value         => $this->getBool('showAlternateProductsTab'),
            LinkTypeEnum::BUNDLED->value           => $this->getBool('showBundledProductsTab'),
            LinkTypeEnum::BUNDLES->value           => $this->getBool('showBundlesTab'),
            LinkTypeEnum::CAPACITY_VARIANTS->value => $this->getBool('showCapacityVariantProductsTab'),
            LinkTypeEnum::COLOR_VARIANTS->value    => $this->getBool('showColorVariantProductsTab'),
            LinkTypeEnum::VARIANTS->value          => $this->getBool('showVariantProductsTab'),
            LinkTypeEnum::RELATED->value           => $this->getBool('showRelatedProductsTab'),
            LinkTypeEnum::SIMILAR->value           => $this->getBool('showSimilarProductsTab'),
        ];
    }

}
