import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import HttpClient from 'src/service/http-client.service';

/**
 * TopdataTopFeedProductDetailTab is a custom plugin that handles the loading of device data
 * when a specific tab is clicked on the product detail page.
 * 
 * @extends Plugin
 */
export default class TopdataTopFeedProductDetailTab extends Plugin {
    /**
     * Default options for the plugin.
     * 
     * @type {Object}
     * @property {string} text - Specifies the text that is prompted to the user.
     * @property {string} itemSelector - Selector of the item to attach the click event.
     */
    static options = {
        text: 'Seems like there\'s nothing more to see here.',
        itemSelector: '.topdata-top-feed-product-devices-load-tab',
    };

    /**
     * Initializes the plugin by setting up the HttpClient and adding the click event listener.
     */
    init() {
        this._client = new HttpClient();
        let TopFeedProductDetailTabElement = DomAccess.querySelector(document, this.options.itemSelector);
        TopFeedProductDetailTabElement.addEventListener('click', this.loadDeviceData.bind(this));
    }

    /**
     * Event handler for loading device data.
     * 
     * @param {Event} event - The click event.
     */
    loadDeviceData(event) {
        event.preventDefault();
        let path = DomAccess.querySelector(document, this.options.itemSelector).dataset.path;
        let container = DomAccess.querySelector(document, '.topdata-top-feed-product-devices-tab-container');

        this._client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                const response = JSON.parse(responseText);
                if (response.success === true) {
                    container.innerHTML = response.html;
                } else {
                    console.log(response);
                }
            } catch (error) {
                console.log(error);
            }
        });
    }
}