import template from './category-detail-topfeed.html.twig';
import './category-detail-topfeed.scss';
//const { mapState, mapGetters } = Shopware.Component.getComponentHelper();
const { Component, Mixin, Context, Data: { Criteria, EntityCollection } } = Shopware;

Component.register('category-detail-topfeed', {
    template: template,

    inject: ['repositoryFactory'],
    
//    mixins: [
//        Mixin.getByName('notification'),
//        Mixin.getByName('listing')
//    ],
    
    data() {
        return {
            test: 'test-value',
            isLoading: true,
            currentLanguageId: Shopware.Context.api.languageId,
            feedSettings: null,
            category: null,
            categoryExtension: null
        };
    },

    metaInfo() {
        return {
            title: this.$tc('topdata-topfeed.tabCategorySettingsMetaTitle')
        };
    },
    
    props: {
        isLoading: {
            type: Boolean,
            required: true
        }
    },
    
    computed: {
        topdataCategoryExtensionRepository() {
            return this.repositoryFactory.create('topdata_category_extension');
        }
    },

    created() {
        this.category = Shopware.State.get('swCategoryDetail').category;
        this.isLoading = true;
        this.loadCategoryFeedSettings();
        this.isLoading = false;
    },
    
//    watch: {
//        category() {
//        }
//    },
    
    methods: {
        loadCategoryFeedSettings() {
            var criteria = new Criteria();
            criteria.addFilter(Criteria.equals('categoryId', this.category.id));
            this.topdataCategoryExtensionRepository.search(criteria, Shopware.Context.api).then((result) => {
                console.log(result);
                let model = result.first();
                if(model) {
                    this.feedSettings = model;
                }
                else {
                    this.feedSettings = this.topdataCategoryExtensionRepository.create(Shopware.Context.api);
                    this.feedSettings.pluginSettings = true;
                    this.feedSettings.categoryId = this.category.id;
                    this.feedSettings.importSettings = {
                        name: false,
                        description: false,
                        brand: true,
                        EANs: true,
                        MPNs: true,
                        pictures: true,
                        unlinkOldPictures: false,
                        properties: true,
                        PCDsProp: false,
                        MPNsProp: false,
                        
                        importSimilar: true,
                        importAlternates: true,
                        importAccessories: true,
                        importBoundles: true,
                        importVariants: true,
                        importColorVariants: true,
                        importCapacityVariants: true,
                        
                        crossSimilar: false,
                        crossAlternates: false,
                        crossAccessories: false,
                        crossBoundles: false,
                        crossVariants: false,
                        crossColorVariants: false,
                        crossCapacityVariants: false
                    };
                }
            });
        },
        
        changeFeedSettings() {
            console.log("changedSettings!");
            this.isLoading = true;
            this.topdataCategoryExtensionRepository
                .save(this.feedSettings, Shopware.Context.api)
                .then(() => {
                    this.loadCategoryFeedSettings();
                    this.isLoading = false;
//                        this.createNotificationSuccess({
//                            title: this.$tc('topdata-rent-products.module.saveSuccessTitle'),
//                            message: this.$tc('topdata-rent-products.module.saveSuccessDescription')
//                        });
                })
                .catch(exception => {
                    this.isLoading = false;
                });
        }
    }
});