<?php declare(strict_types=1);

namespace Topdata\TopdataTopFeedSW6\Storefront\Page\CompatibleDevicesWidget;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFeedSW6\Service\SettingsService;
use Doctrine\DBAL\Connection;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;

class CompatibleDevicesWidgetLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;
    
    /**
     * @var Connection
     */
    private $connection;
    
    /**
     * @var SalesChannelRepository
     */
    private $productRepository;

    public function __construct(
        GenericPageLoader $genericLoader,
        Connection $connection,
        private readonly SettingsService $settingsService,
        SalesChannelRepository $productRepository
    ) {
        $this->genericLoader = $genericLoader;
        $this->connection = $connection;
        $this->productRepository = $productRepository;
    }
    
    public function load(Request $request, SalesChannelContext $salesChannelContext, string $productid): CompatibleDevicesWidget
    {
        /** @var CompatibleDevicesWidget $page */
        $page = CompatibleDevicesWidget::createFrom(
                $this->genericLoader->load($request, $salesChannelContext)
            );
        $page->product = $this->searchProduct($productid, $salesChannelContext);
        $page->setDevices($this->searchDevices($productid));
        
        return $page;
    }
    
    private function searchProduct(string $productid, SalesChannelContext $salesChannelContext) : ?SalesChannelProductEntity
    {
        return $this
            ->productRepository
            ->search(
                (new Criteria([$productid]))->addAssociation('manufacturer'), 
                $salesChannelContext
            )
            ->getEntities()
            ->first();
    }
    
    private function searchDevices(string $productid) : array
    {
        $devices = $this->connection->fetchAllAssociative('
SELECT topdata_device.model as name, 
       LOWER(HEX(topdata_device.id)) as id, 
       LOWER(HEX(topdata_device.brand_id)) as brand_id, 
       LOWER(HEX(topdata_device.series_id)) as series_id, 
       LOWER(HEX(topdata_device.type_id)) as type_id, 
       topdata_device.code as code, 
       topdata_brand.label as brand_name,
       topdata_series.label as series_name,
       topdata_device_type.label as type_name
  FROM topdata_device_to_product, 
       topdata_brand,
       topdata_device
  LEFT JOIN `topdata_series` ON `topdata_device`.series_id = `topdata_series`.`id`
  LEFT JOIN topdata_device_type ON `topdata_device`.`type_id` = `topdata_device_type`.`id`
  WHERE (topdata_device.is_enabled=1)
        AND(topdata_device_to_product.product_id=0x'.$productid.')
        AND(topdata_device_to_product.device_id = topdata_device.id)
        AND(topdata_brand.id=topdata_device.brand_id)
  ORDER BY topdata_brand.label, topdata_series.label, topdata_device.model
            ');
        
        return $devices;
    }
}
