<?php declare(strict_types=1);

namespace Topdata\TopdataProductBoxesSW6;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Topdata\TopdataFoundationSW6\DependencyInjection\TopConfigRegistryCompilerPass;

/**
 * 08/2023 created
 */
class TopdataProductBoxesSW6 extends Plugin
{

    const MAPPINGS = [
        // TODO...
    ];

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        // ---- register the plugin in Topdata Configration Center's TopConfigRegistry
        if(class_exists(TopConfigRegistryCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigRegistryCompilerPass(__CLASS__, self::MAPPINGS));
        }
    }


    /**
     * When uninstalling a plugin, the user is asked if he really wants to delete all
     * the plugin data. The method keepUserData of the UninstallContext will provide
     * the users decision. If keepUserData returns true, you should not remove important
     * data of your plugin, the user wants to keep them.
     */
    public function uninstall(UninstallContext $uninstallContext): void
    {

        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }


        // ---- drop tables
        $connection = $this->container->get(Connection::class);
        if (!$connection) {
            return;
        }

        $connection->executeStatement('
            
            DROP TABLE IF EXISTS topdata_pb_category_extension_to_property_group;
            DROP TABLE IF EXISTS topdata_pb_category_extension;

        ');

    }

}