<?php

namespace Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup;

use Shopware\Core\Content\Property\PropertyGroupEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityCustomFieldsTrait;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Topdata\TopdataProductBoxesSW6\Entity\Extension\TopdataPbCategoryExtension\TopdataPbCategoryExtensionEntity;


/**
 * junction table between 
 *
 * 08/2023 created
 */
class TopdataPbCategoryExtensionToPropertyGroupEntity extends Entity
{
    use EntityIdTrait;
    use EntityCustomFieldsTrait;
    protected int $position;

    /**
     * @var array assoc array, format: [localeCode => nameOverride], eg: ['de-DE' => 'My Custom Property Group Name']
     */
    protected array $nameOverrides = [];



    protected string $topdataPbCategoryExtensionId;
    protected ?TopdataPbCategoryExtensionEntity $topdataPbCategoryExtension = null;


    protected string $propertyGroupId;
    protected ?PropertyGroupEntity $propertyGroup = null;

    public function getTopdataPbCategoryExtension(): ?TopdataPbCategoryExtensionEntity
    {
        return $this->topdataPbCategoryExtension;
    }

    public function getPropertyGroup(): ?PropertyGroupEntity
    {
        return $this->propertyGroup;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function getPropertyGroupId()
    {
        return $this->propertyGroupId;
    }

    public function getTopdataPbCategoryExtensionId(): string
    {
        return $this->topdataPbCategoryExtensionId;
    }

    public function getNameOverrides(): array
    {
        return $this->nameOverrides;
    }

    public function setNameOverrides(array $nameOverrides): void
    {
        $this->nameOverrides = $nameOverrides;
    }


}