<?php

namespace Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup;


use Shopware\Core\Content\Property\PropertyGroupDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\CreatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\CustomFields;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\ApiAware;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\JsonField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Topdata\TopdataProductBoxesSW6\Entity\Extension\TopdataPbCategoryExtension\TopdataPbCategoryExtensionDefinition;
use Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup\TopdataPbCategoryExtensionToPropertyGroupEntity;

/**
 * junction table
 *
 * 08/2023 created
 */
class TopdataPbCategoryExtensionToPropertyGroupDefinition extends EntityDefinition // extends MappingEntityDefinition
{
    const ENTITY_NAME = 'topdata_pb_category_extension_to_property_group';

    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    public function getEntityClass(): string
    {
        return TopdataPbCategoryExtensionToPropertyGroupEntity::class;
    }

    public function getCollectionClass(): string
    {
        return TopdataPbCategoryExtensionToPropertyGroupCollection::class;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),

            // ---- m:1 relation to category extension
            (new FkField('topdata_pb_category_extension_id', 'topdataPbCategoryExtensionId', TopdataPbCategoryExtensionDefinition::class))->addFlags(new Required()),
            new ManyToOneAssociationField('topdataPbCategoryExtension', 'topdata_pb_category_extension_id', TopdataPbCategoryExtensionDefinition::class, 'id', false),

            // ---- m:1 relation to property group
            (new FkField('property_group_id', 'propertyGroupId', PropertyGroupDefinition::class))->addFlags(new Required()),
            new ManyToOneAssociationField('propertyGroup', 'property_group_id', PropertyGroupDefinition::class, 'id', false),

            new IntField('position', 'position'),
            new CustomFields(),
            new JsonField('name_overrides', 'nameOverrides'),

            new CreatedAtField(),
        ]);
    }

}

