<?php declare(strict_types=1);

namespace Topdata\TopdataProductBoxesSW6\Entity\Extension\TopdataPbCategoryExtension;

use Shopware\Core\Content\Category\CategoryDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\AssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\BoolField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ListField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup\TopdataPbCategoryExtensionToPropertyGroupDefinition;

/**
 * we extend sw6 category to add a role and a reference to TopdataOrganization
 *
 * 08/2023 created
 */
class TopdataPbCategoryExtensionDefinition extends EntityDefinition
{
    public const ENTITY_NAME = 'topdata_pb_category_extension';

    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    public function getEntityClass(): string
    {
        return TopdataPbCategoryExtensionEntity::class;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([

            (new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),

            // ---- 1:1 relation to category
            (new FkField('category_id', 'categoryId', CategoryDefinition::class))->addFlags(new Required()),
            new OneToOneAssociationField('category', 'category_id', 'id', CategoryDefinition::class, false),

//            // ---- m:n relation to property groups (via join table)
            (new OneToManyAssociationField('propertyGroupXrefs', TopdataPbCategoryExtensionToPropertyGroupDefinition::class, 'topdata_pb_category_extension_id', 'id')),

            // ---- plugin settings on category level
            (new BoolField('use_parent_category', 'useParentCategory'))->addFlags(new Required()),
            (new BoolField('is_enabled', 'isEnabled'))->addFlags(new Required()),
        ]);
    }
}