<?php

namespace Topdata\TopdataProductBoxesSW6\Entity\Extension;

use Shopware\Core\Content\Category\CategoryDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Topdata\TopdataProductBoxesSW6\Entity\Extension\TopdataPbCategoryExtension\TopdataPbCategoryExtensionDefinition;

/**
 * 08/2023 created
 */
class TopdataPbCategoryExtension extends EntityExtension
{
    public function extendFields(FieldCollection $collection): void
    {
        // ---- 1:1 relation category:topdataPbCategoryExtension
        $collection->add(
            (new OneToOneAssociationField(
                'topdataPbCategoryExtension',
                'id',
                'category_id',
                TopdataPbCategoryExtensionDefinition::class,
                true
            ))->addFlags(new CascadeDelete())
        );
    }

    public function getDefinitionClass(): string
    {
        return CategoryDefinition::class;
    }
}
