<?php

namespace Topdata\TopdataProductBoxesSW6\Controller\Administration;


use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Topdata\TopdataProductBoxesSW6\Manager\PropertyGroupManager;


/**
 * 08/2023 created
 */
#[Route(defaults: ['_routeScope' => ['administration']])]
class TopdataProductBoxesAdministrationController extends AbstractAdministrationController
{
    public function __construct(
        private readonly EntityRepository     $topdataPbCategoryExtensionRepository,
        private readonly PropertyGroupManager $propertyGroupManager
    )
    {
    }


    /**
     * UPDATE existing topdataPbCategoryExtension
     *
     * 08/2023 created
     */
    #[Route(path: '/api/topdata-product-boxes/update-topdata-pb-category-extension/{topdataPbCategoryExtensionId}', methods: ['PUT'])]
    public function updateTopdataPbCategoryExtensionAction(string $topdataPbCategoryExtensionId, Request $request, Context $context): JsonResponse
    {
        $postData = $request->request->all();

        // ---- upsert TopdataPbCategoryExtension
        $payload = [
            'id'                => $topdataPbCategoryExtensionId,
            'categoryId'        => $postData['categoryId'],
            'isEnabled'         => $postData['isEnabled'],
            'useParentCategory' => $postData['useParentCategory'],
        ];
        $existing = $this->topdataPbCategoryExtensionRepository->searchIds(new Criteria([$topdataPbCategoryExtensionId]), $context)->firstId();
        if ($existing) {
            $this->topdataPbCategoryExtensionRepository->update([$payload], $context);
        } else {
            $this->topdataPbCategoryExtensionRepository->create([$payload], $context);
        }

        // ---- propertyGroupXrefs entities
        $this->propertyGroupManager->updatePropertyGroupsOfTopdataPbCategoryExtension($topdataPbCategoryExtensionId, $postData['propertyGroups'], $context);


        return $this->successResponse();
    }


}