# TopdataProductBoxesSW6 V2

NOTE: This is version 2 (in branch main) for sw66. For sw64, use version 1 (in branch main-v1)!


## Installation

- plugins with an older installation date will be higher up in the list in the TemplateFinder and their template will be returned.
- to be sure that the correct theme is loaded, define the order in the theme: https://stackoverflow.com/questions/66627911/in-which-order-are-shopware-6-plugins-loaded/67841990#67841990
- example: custom/plugin/MyTheme/src/Resources/theme.json

```json5
{
    // ...
    "views": [
        "@Storefront",
        "@Plugins",
        "@MyTheme",
        "@TopdataProductBoxesSW6" // <-- this is the important line, put it at the end so it overwrites the other templates
    ],
    // ...
}
```

Another way is to include the partial directly in the template (eg in `@YourTheme/storefront/component/product/card/box-standard.html.twig`):
```twig
    {% include '@TopdataProductBoxesSW6/storefront/component/product/card/_category-specific-properties.html.twig' %}
```


## Database tables

### Table Prefix
`topdata_pb_`

### Tables
- `topdata_pb_category_extension`
- `topdata_pb_category_extension_to_property_group`


## Theme
it overwrites the block `component_product_box_name` in `vendor/shopware/storefront/Resources/views/storefront/component/product/card/box-standard.html.twig`


## CSS classes
The plugin adds the following CSS classes to the product box:

- `.TopdataProductBoxesSW6_boxProperties` wrapper around the properties
- `.TopdataProductBoxesSW6_propertyGroup_{propertyGroupId}` wrapper around a row with property group name and property value/s

