<?php declare(strict_types=1);

namespace Topdata\TopdataProductBoxesSW6;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;

/**
 * 08/2023 created
 */
class TopdataProductBoxesSW6 extends Plugin
{
    /**
     * When uninstalling a plugin, the user is asked if he really wants to delete all
     * the plugin data. The method keepUserData of the UninstallContext will provide
     * the users decision. If keepUserData returns true, you should not remove important
     * data of your plugin, the user wants to keep them.
     */
    public function uninstall(UninstallContext $uninstallContext): void
    {

        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }


        // ---- drop tables
        $connection = $this->container->get(Connection::class);
        if (!$connection) {
            return;
        }

        $connection->executeStatement('
            
            DROP TABLE IF EXISTS topdata_pb_category_extension_to_property_group;
            DROP TABLE IF EXISTS topdata_pb_category_extension;

        ');

    }

}