// ---- components
import './component/sw-category-view-override';
import './component/category-detail-product-boxes-settings';

// ---- snippets
import deDE from './snippet/de-DE.json';
//import enGB from './snippet/en-GB.json';

Shopware.Module.register('topdata-product-boxes-sw6', {


    // ---- register a route
    routeMiddleware(next, currentRoute) {
        if (currentRoute.name === 'sw.category.detail') {
            currentRoute.children.push({
                name:      'sw.category.detail.topdata-product-boxes',
                path:      '/sw/category/index/:id/topdata-product-boxes',
                component: 'category-detail-product-boxes-settings',
                meta:      {
                    parentPath: "sw.category.index"
                }
            });
        }
        next(currentRoute);
    },
    snippets: {
        'de-DE': deDE,
//        'en-GB': enGB
    },
});


