import template from './category-detail-product-boxes-settings.html.twig';

const {Component} = Shopware;


Component.register('category-detail-product-boxes-settings', { // <-- same name like the directory to make it non-confusing
    template: template,

    inject: [
        'repositoryFactory',
        'TopdataPbCategoryExtensionApiService',
    ],

    data() {
        return {
            isLoading: false,
            choices:                    [],
            topdataPbCategoryExtension: null, // <-- this is the entity were the settings are stored, fetched from server
        };
    },

    metaInfo() {
        return {
            title: this.$tc('TopdataProductBoxesSW6.productBoxSettings.pageTitle')
        };
    },

    computed: {
        topdataPbCategoryExtensionRepository() {
            return this.repositoryFactory.create('topdata_pb_category_extension');
        }
    },

    created() {
        this.category = Shopware.State.get('swCategoryDetail').category;
        this.loadCategoryExtension();
    },

    methods: {
        loadCategoryExtension() {
            // TODO: this belongs in the TopdataPbCategoryExtensionApiService
            const criteria = new Shopware.Data.Criteria();
            criteria.addAssociation('propertyGroupXrefs');
            criteria.getAssociation('propertyGroupXrefs').addSorting(Shopware.Data.Criteria.sort('position', 'ASC'));
            criteria.addAssociation('propertyGroupXrefs.propertyGroup');
            criteria.addFilter(Shopware.Data.Criteria.equals('categoryId', this.category.id));
            this.topdataPbCategoryExtensionRepository.search(criteria, Shopware.Context.api).then((result) => {
                console.log(result);
                const model = result.first();
                if (model) {
                    // ---- existing category extension
                    this.topdataPbCategoryExtension = model;
                    this.topdataPbCategoryExtension.propertyGroups = this.topdataPbCategoryExtension.propertyGroupXrefs.map((x) => {
                        return x.propertyGroup;
                    });
                } else {
                    // ---- new category extension
                    this.topdataPbCategoryExtension = {
                        id:                Shopware.Utils.createId(),
                        categoryId:        this.category.id,
                        useParentCategory: true,
                        isEnabled:         true,
                        propertyGroups:    [],
                    }
                }
            });
        },
        saveCategoryExtension() {
            this.isLoading = true;
            console.log("saveCategoryExtension", this.topdataPbCategoryExtension);
            this.TopdataPbCategoryExtensionApiService.updateTopdataPbCategoryExtension(this.topdataPbCategoryExtension).then(() => {
                this.isLoading = false;
            })
        },
    },
    watch:   {
        topdataPbCategoryExtension: {
            handler(newValue, oldValue) {
                console.log("topdataPbCategoryExtension changed", {newValue, oldValue});
                if (!oldValue) {
                    return;
                }
                this.saveCategoryExtension();
            },
            deep:      true,
            immediate: true,
        },
    }
});