<?php declare(strict_types=1);

namespace Topdata\TopdataProductBoxesSW6\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1693253489 extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1693253489;
    }

    public function update(Connection $connection): void
    {


        // ---- category extension
        $SQL = "
            CREATE TABLE IF NOT EXISTS topdata_pb_category_extension (
                          id BINARY(16) NOT NULL,
                          category_id BINARY(16) NOT NULL,
                          created_at DATETIME NULL,
                          updated_at DATETIME NULL,
                          is_enabled TINYINT DEFAULT 1 COMMENT 'is the extension enabled for this category?',
                          use_parent_category TINYINT DEFAULT 0 COMMENT 'use the properties defined in a parent category',
                          PRIMARY KEY (id),
                          UNIQUE KEY UX__category (category_id),

                          CONSTRAINT FK__tpce__category__id             
                                FOREIGN KEY (category_id)             
                                REFERENCES category (id) 
                                ON DELETE CASCADE ON UPDATE CASCADE
                
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

        ";
        $connection->executeStatement($SQL);
        
        // ---- topdata_pb_category_extension_to_property_group (join table)
        $SQL = "
            CREATE TABLE IF NOT EXISTS topdata_pb_category_extension_to_property_group (
                id BINARY(16) NOT NULL,
                topdata_pb_category_extension_id BINARY(16) NOT NULL,
                property_group_id BINARY(16) NOT NULL,
                `position` INTEGER DEFAULT 0, -- as the order is important
                created_at DATETIME NOT NULL,
                updated_at DATETIME NULL,
                custom_fields JSON NULL,
                name_overrides JSON NULL,
                
                PRIMARY KEY (id),
                UNIQUE KEY UX__topdata_pb_category_extension_id__property_group_id (topdata_pb_category_extension_id, property_group_id),
                INDEX IX__topdata_pb_category_extension_id (topdata_pb_category_extension_id),
                INDEX IX__property_group_id (property_group_id),
                CONSTRAINT JSON__tdpbcetpg__custom_fields CHECK (JSON_VALID(custom_fields)),
                CONSTRAINT JSON__tdpbcetpg__name_overrides CHECK (JSON_VALID(name_overrides)),

                            CONSTRAINT FK__tdpbcetpg__topdata_pb_category_extension__id
                                FOREIGN KEY (topdata_pb_category_extension_id) 
                                REFERENCES topdata_pb_category_extension (id) 
                                ON DELETE CASCADE ON UPDATE CASCADE,

                            CONSTRAINT FK__tdpbcetpg__property_group__id
                                FOREIGN KEY (property_group_id) 
                                REFERENCES property_group (id) 
                                ON DELETE CASCADE ON UPDATE CASCADE

                
                
            )
            ENGINE = InnoDB
            DEFAULT CHARSET = utf8mb4
            COLLATE = utf8mb4_unicode_ci
";

        $connection->executeStatement($SQL);


    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
