<?php declare(strict_types=1);

namespace Topdata\TopdataProductBoxesSW6\Entity\Extension\TopdataPbCategoryExtension;

use Shopware\Core\Content\Category\CategoryEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup\TopdataPbCategoryExtensionToPropertyGroupCollection;
use Topdata\TopdataProductBoxesSW6\Entity\TopdataPbCategoryExtensionToPropertyGroup\TopdataPbCategoryExtensionToPropertyGroupEntity;

/**
 * 08/2023 created
 */
class TopdataPbCategoryExtensionEntity extends Entity
{
    use EntityIdTrait;

    protected string $categoryId;
//    protected CategoryEntity $category;
    protected bool $isEnabled;
    protected bool $useParentCategory;

    protected TopdataPbCategoryExtensionToPropertyGroupCollection $propertyGroupXrefs;

    /**
     * @param TopdataPbCategoryExtensionToPropertyGroupCollection $propertyGroupXrefs
     */
    public function __construct()
    {
        $this->propertyGroupXrefs = new TopdataPbCategoryExtensionToPropertyGroupCollection();
    }


    public function getCategoryId(): string
    {
        return $this->categoryId;
    }

//    public function getCategory(): CategoryEntity
//    {
//        return $this->category;
//    }

    public function getPropertyGroupXrefs(): TopdataPbCategoryExtensionToPropertyGroupCollection
    {
        return $this->propertyGroupXrefs;
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function getUseParentCategory(): bool
    {
        return $this->useParentCategory;
    }

//    public function getPropertyGroups()
//    {
//        return $this->propertyGroupXrefs->map(function (TopdataPbCategoryExtensionToPropertyGroupEntity $xref) {
//            return $xref->getPropertyGroup();
//        });
//    }

}