<?php declare(strict_types=1);


namespace Topdata\TopdataProductBoxesSW6\Controller\Administration;


use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Shopware\Core\Framework\Api\Context\AdminApiSource;
use Shopware\Core\Framework\Api\Context\Exception\InvalidContextSourceException;
use Shopware\Core\Framework\Api\Controller\Exception\ExpectedUserHttpException;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\User\UserEntity;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;


/**
 * 08/2023 created
 */
class AbstractAdministrationController extends AbstractController
{

    protected EntityRepository $userRepository;

    /**
     * @required
     */
    public function setUserRepository(EntityRepository $userRepository): void
    {
        $this->userRepository = $userRepository;
    }


    /**
     * 06/2023 created
     *
     * @return JsonResponse
     */
    protected function payloadResponse(mixed $payload): JsonResponse
    {
        $body = [
            'success' => true,
            'payload' => $payload,
        ];

        return new JsonResponse($body, Response::HTTP_OK);
    }

    /**
     * 06/2023 created
     *
     * @param string|null $message
     * @return JsonResponse
     */
    public function successResponse(?string $message = null, mixed $payload = null): JsonResponse
    {
        $body = [
            'success' => true,
            'message' => $message,
            'payload' => $payload,
        ];

        return new JsonResponse($body, Response::HTTP_OK);
    }


    /**
     * returns id of the logged-in admin user
     *
     * 06/2023 created
     *
     * @param Context $context
     * @return string sw6Id of the logged-in admin user
     */
    protected function _getUserId(Context $context): string
    {
        if (!$context->getSource() instanceof AdminApiSource) {
            throw new InvalidContextSourceException(AdminApiSource::class, $context->getSource()::class);
        }

        $userId = $context->getSource()->getUserId();
        if (!$userId) {
            throw new ExpectedUserHttpException();
        }

        return $userId;
    }

    /**
     * returns the logged-in admin user
     *
     * 06/2023 created
     *
     * @param Context $context
     * @return UserEntity
     */
    protected function _getUser(Context $context): UserEntity
    {
        $userId = $this->_getUserId($context);
        $criteria = new Criteria([$userId]);

        return $this->userRepository->search($criteria, $context)->first();
    }


    /**
     * returns the full name and username of the logged-in admin user as string
     *
     * 06/2023 created
     *
     * @param Context $context
     * @return string
     */
    protected function _getUserName(Context $context): string
    {
        $user = $this->_getUser($context);
        $fullname = trim($user->getFirstName() . ' ' . $user->getLastName());
        return "$fullname (" . $user->getUsername() . ")";
    }

}
