---
title: Configuration
---

# Plugin Configuration

All settings for the Topdata Private Shop plugin can be found in the Shopware Administration under `Extensions` > `My extensions` > `Topdata Private shop` > `Configuration`.

The plugin offers two main settings:

### Private Shop Mode

This setting controls what non-logged-in (guest) users can see on the storefront.

-   **Hide Categories and Products:** This is the most restrictive mode.
    -   The main navigation menu is hidden.
    -   Category pages are inaccessible and will redirect to the login page.
    -   Product detail pages are inaccessible and will redirect to the login page.
    -   Product sliders and product boxes on landing pages are hidden.
    -   The cart widget, prices, and "Add to Cart" buttons are hidden everywhere.

-   **Hide Products:** In this mode, guests can browse categories, but cannot see products.
    -   Category pages are visible, but product listings are replaced with a "Product is visible after login" placeholder.
    -   Product detail pages are inaccessible and will redirect to the login page.
    -   Search results are inaccessible and will redirect to the login page.
    -   The cart widget, prices, and "Add to Cart" buttons are hidden everywhere.

-   **Hide Prices:** In this mode, guests can browse all categories and products, but cannot see prices or make purchases.
    -   All product and category pages are visible.
    -   All prices are replaced with a "Login to see prices" link.
    -   All "Add to Cart" buttons are hidden or replaced with a login link.
    -   The cart widget is hidden.

-   **Hide Nothing:** The plugin's private shop functionality is disabled. All users can see all content, prices, and can add products to the cart. The shop behaves like a standard public store.

### Disable Registration

This is a boolean switch to control new customer registrations.

-   **Enabled (Checked):** The customer registration form is hidden on the `/account/login` page and during the checkout process. A message is displayed informing the user that registration is disabled.
-   **Disabled (Unchecked):** The standard Shopware registration form is available to all users.
