# Topdata Private Shop Plugin for Shopware 6

![topdata-private-shop-sw6-256x256.png](src/Resources/config/topdata-private-shop-sw6-256x256.png)

## About

- 08/2025 created

## Installation and Update

### Minimal Requirements
- Shopware 6.7
- PHP 8.2

### Installation
- clone this repository into your shopware installation's `custom/plugins` directory
- run `bin/console plugin:refresh`
- run `bin/console plugin:install TopdataPrivateShopSW6 -ac`

### Update
- pull the latest changes from the repository
- check if there is update available: `bin/console plugin:refresh`
- then run `bin/console plugin:update TopdataPrivateShopSW6 -c`
- check if update was successful: `bin/console plugin:list`

## Features

### Private Shop

There are multiple settings for the plugin in plugin config:
- `Private Shop Mode` - What to hide for non-logged-in customers
  - HIDE_PRODUCTS_AND_CATEGORIES - hide all products and prices and categories
  - HIDE_PRODUCTS - hide all products and prices
  - HIDE_PRICES - hide all prices
  - HIDE_NOTHING - show everything (no private shop)

- `Disable Registration` - Disable customer registration in the shop

#### Theme-Configuration

In order to make the private shop feature work, you need to add the following to your theme configuration:

```json5
{
  // ...
  "views": [
    "@Storefront",
    "@Plugins",
    "@MyTheme",
    "@TopdataPrivateShopSW6" // <-- add this at the end of the list so that it can hide stuff in the templates 
  ],
  // ...
}
```
