---
title: Installation
---

# Installationsanleitung

Befolgen Sie diese Schritte, um das Plugin in Ihrer Shopware-6-Umgebung zu installieren und zu aktivieren.

### 1. Systemanforderungen

-   Shopware 6.7 oder höher
-   PHP 8.2 oder höher

### 2. Plugin-Installation

1.  Klonen oder laden Sie dieses Repository in das Verzeichnis `custom/plugins/` Ihres Shops. Der endgültige Pfad sollte `custom/plugins/TopdataPrivateShopSW6` lauten.
2.  Verbinden Sie sich per SSH mit Ihrem Server und navigieren Sie zum Hauptverzeichnis Ihrer Shopware-Installation.
3.  Aktualisieren Sie die Plugin-Liste, damit Shopware das neue Plugin erkennt:
    ```bash
    bin/console plugin:refresh
    ```
4.  Installieren und aktivieren Sie das Plugin. Die Flags `-ac` aktivieren es automatisch und leeren den Cache.
    ```bash
    bin/console plugin:install TopdataPrivateShopSW6 -ac
    ```

### 3. Theme-Konfiguration (Entscheidender Schritt)

Damit die Sichtbarkeitsregeln des Plugins korrekt funktionieren, **müssen** Sie dessen Template-Verzeichnis in Ihrem aktiven Storefront-Theme registrieren.

1.  Finden Sie die Datei `theme.json` für Ihr aktives Theme. Diese befindet sich normalerweise unter `custom/plugins/MyTheme/src/Resources/theme.json`.
2.  Suchen Sie das `"views"`-Array in der Konfiguration.
3.  Fügen Sie `@TopdataPrivateShopSW6` am **Ende** dieses Arrays hinzu. Dadurch wird sichergestellt, dass die Templates des Plugins die letzte Entscheidung darüber haben, was ausgeblendet wird.

**Beispiel `theme.json`:**
```json5
{
  "name": "MyTheme",
  // ... andere Einstellungen
  "views": [
    "@Storefront",
    "@Plugins",
    "@MyTheme",
    "@TopdataPrivateShopSW6" // <-- Fügen Sie diese Zeile am Ende hinzu
  ],
  // ... andere Einstellungen
}
```

4.  Nachdem Sie die Datei `theme.json` gespeichert haben, müssen Sie Ihr Theme neu kompilieren, damit die Änderungen wirksam werden:
    ```bash
    bin/console theme:compile
    ```

Die Installation ist nun abgeschlossen. Sie können mit der Plugin-Konfiguration fortfahren.
