<?php

namespace Topdata\TopdataPrivateShopSW6\Constants;

/**
 * Defines constants for different private shop modes, controlling the visibility of products, categories, and prices.
 * These constants are used to configure the level of protection applied to the shop.
 * 09/2023 created
 */
class PrivateShopModeConstants
{
    const HIDE_PRODUCTS_AND_CATEGORIES = 'HIDE_PRODUCTS_AND_CATEGORIES'; // highest protection
    const HIDE_PRODUCTS                = 'HIDE_PRODUCTS'; // 2nd highest protection
    const HIDE_PRICES                  = 'HIDE_PRICES'; // 3rd highest protection
    const HIDE_NOTHING                 = 'HIDE_NOTHING'; // no protection


    /**
     * Determines whether categories should be hidden based on the given private shop mode.
     *
     * 09/2023 created
     *
     * @param string $privateShopMode The private shop mode to check.
     * @return bool True if categories should be hidden, false otherwise.
     */
    public static function hideCategories(string $privateShopMode): bool
    {
        return in_array($privateShopMode, [
            self::HIDE_PRODUCTS_AND_CATEGORIES,
        ]);
    }

    /**
     * Determines whether products should be hidden based on the given private shop mode.
     *
     * @param string $privateShopMode The private shop mode to check.
     * @return bool True if products should be hidden, false otherwise.
     */
    public static function hideProducts(string $privateShopMode): bool
    {
        return in_array($privateShopMode, [
            self::HIDE_PRODUCTS_AND_CATEGORIES,
            self::HIDE_PRODUCTS,
        ]);
    }

    /**
     * Determines whether prices should be hidden based on the given private shop mode.
     *
     * @param string $privateShopMode The private shop mode to check.
     * @return bool True if prices should be hidden, false otherwise.
     */
    public static function hidePrices(string $privateShopMode): bool
    {
        return in_array($privateShopMode, [
            self::HIDE_PRODUCTS_AND_CATEGORIES,
            self::HIDE_PRODUCTS,
            self::HIDE_PRICES,
        ]);
    }

}