---
title: Installation
---

# Installation Guide

Follow these steps to install and activate the plugin in your Shopware 6 environment.

### 1. System Requirements

- Shopware 6.7 or higher
- PHP 8.2 or higher

### 2. Plugin Installation

1.  Clone or download this repository into your shop's `custom/plugins/` directory. The final path should be `custom/plugins/TopdataPrivateShopSW6`.
2.  Connect to your server via SSH and navigate to your Shopware root directory.
3.  Refresh the plugin list to make Shopware aware of the new plugin:
    ```bash
    bin/console plugin:refresh
    ```
4.  Install and activate the plugin. The `-ac` flags will automatically activate it and clear the cache.
    ```bash
    bin/console plugin:install TopdataPrivateShopSW6 -ac
    ```

### 3. Theme Configuration (Crucial Step)

For the plugin's visibility rules to work correctly, you **must** register its template directory in your active storefront theme.

1.  Locate the `theme.json` file for your active theme. This is typically found in `custom/plugins/MyTheme/src/Resources/theme.json`.
2.  Find the `"views"` array within the configuration.
3.  Add `@TopdataPrivateShopSW6` to the **end** of this array. This ensures its templates have the final say on what gets hidden.

**Example `theme.json`:**
```json5
{
  "name": "MyTheme",
  // ... other settings
  "views": [
    "@Storefront",
    "@Plugins",
    "@MyTheme",
    "@TopdataPrivateShopSW6" // <-- Add this line at the end
  ],
  // ... other settings
}
```

4.  After saving the `theme.json` file, you must recompile your theme for the changes to take effect:
    ```bash
    bin/console theme:compile
    ```

The installation is now complete. You can proceed to the plugin configuration.
