# Topdata Private Shop Plugin for Shopware 6

![Plugin Icon](src/Resources/config/topdata-private-shop-sw6-256x256.png)

## Description

This plugin transforms your Shopware 6 store into a private B2B shop by hiding products, categories, and prices from non-logged-in users. It also provides a simple but powerful option to completely disable new customer registrations, making it ideal for wholesale or members-only stores.

## Features

- **Private Shop Mode:** Control storefront visibility for guest users with four distinct levels:
    - Hide Categories and Products
    - Hide Products
    - Hide Prices
    - Show Everything (Public Shop)

- **Disable Registration:** Globally disable the customer registration form across the storefront, including the main account page and the checkout process.

- **Automatic Guest Redirects:** Automatically redirects guests to the login page when they try to access protected content like product detail pages or search results.

- **Clean User Interface:** Hides "Add to Cart" buttons, the entire cart widget, and prices in search suggestions for a seamless private shop experience.

## Documentation

For detailed installation and configuration instructions, please see the user manual in the `manual/` directory.
