<?php declare(strict_types=1);

namespace Topdata\TopdataListingProperties\Subscriber;

use Shopware\Core\Content\Product\Events\ProductListingCriteriaEvent;
use Shopware\Core\Content\Product\Events\ProductDetailRouteCriteriaEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductPropertiesSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            ProductListingCriteriaEvent::class     => 'onListingCriteria',
            ProductDetailRouteCriteriaEvent::class => 'onDetailCriteria',
        ];
    }

    public function onListingCriteria(ProductListingCriteriaEvent $event): void
    {
        $criteria = $event->getCriteria();

        // Lädt die Eigenschaften + Gruppe + Name der Option
        $criteria->addAssociation('properties.group');

        // Wichtig: Übersetzungen der Optionen (damit "cyan" auch wirklich als Text da ist)
        $criteria->addAssociation('properties.group.translations');
    }

    public function onDetailCriteria(ProductDetailRouteCriteriaEvent $event): void
    {
        $criteria = $event->getCriteria();

        // Genau dasselbe wie im Listing – für die Detailseite
        $criteria->addAssociation('properties.group');
        $criteria->addAssociation('properties.group.translations');
    }
}