# Topdata Listing Properties SW6

![plugin.png](src/Resources/config/plugin.png)

A Shopware 6 plugin that loads product properties in listing pages and detail pages.

## Description

This plugin enhances Shopware 6 by automatically loading product properties along with their groups and translations in product listings and detail pages. This ensures that product properties are available when rendering product cards and detail views without additional API calls.

## Features

- Automatically loads product properties in listing pages
- Includes property groups and translations
- Works for both product listing and detail pages
- Optimized performance with proper associations

## Installation

1. Install the plugin via composer:
   ```bash
   composer require topdata/topdata-listing-properties-sw6
   ```

2. Install and activate the plugin in the Shopware Administration:
   - Navigate to `Settings` → `System` → `Plugins`
   - Find "Topdata Listing Properties SW6" and install it
   - Activate the plugin

## Requirements

- Shopware 6.5.x, 6.6.x, or 6.7.x
- PHP 8.0 or higher

## How it works

The plugin subscribes to Shopware's product listing and detail criteria events and automatically adds the necessary associations:

- `properties.group` - Loads property groups
- `properties.group.translations` - Loads translations for property groups

This ensures that when products are loaded in listings or detail pages, all property information is available in the same API response.

## Support

For support and questions, please contact:
- **TopData Software GmbH**
- **Website**: https://www.topdata.de

## License

This plugin is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## Copyright

(c) by TopData Software GmbH
