<?php declare(strict_types=1);

namespace Topdata\TopdataLinkedOemRemSW6\Constants;

class SavingsCalculationStrategyConstants
{
    /**
     * Always performs a simple price comparison (e.g., €15 vs €20).
     * This can be misleading if capacities differ.
     */
    public const STRATEGY_SIMPLE = 'simple';

    /**
     * Always attempts a normalized, "fair" comparison based on price-per-unit
     * if capacities are available. Falls back to simple comparison if not.
     */
    public const STRATEGY_NORMALIZED = 'normalized';
}