<?php declare(strict_types=1);


namespace Topdata\TopdataLinkedOemRemSW6\Command;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Topdata\TopdataLinkedOemRemSW6\Foundation\Command\AbstractTopdataCommand;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemLinkerService;

/**
 * 11/2023 created
 */
#[AsCommand(
    name: 'topdata:linked-oem-rem:refresh-links',
    description: 'fills the table topdata_lor_oem_to_rem with links between oem and rem products'
)]
class Command_RefreshLinks extends AbstractTopdataCommand
{
    public function __construct(
        private readonly OemRemLinkerService $oemRemLinkerService,
    )
    {
        parent::__construct();
    }

    /**
     * ==== MAIN ====
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->oemRemLinkerService->refreshLinks();
        $this->done();

        return Command::SUCCESS;
    }

}
