<?php


namespace Topdata\TopdataLinkedOemRemSW6\Twig;


use Shopware\Core\Checkout\Cart\Cart;
use Shopware\Core\Checkout\Cart\LineItem\LineItem;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\Framework\Context;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Topdata\TopdataLinkedOemRemSW6\DTO\SavingsOverOemDTO;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemProductFinderService;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemSavingsService;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;


/**
 * 11/2023 created
 */
class MyTwigExtension extends AbstractExtension
{
    private OemRemProductFinderService $productFinderService;
    private OemRemSavingsService $savingsService;

    public function __construct(
        OemRemProductFinderService $productFinderService,
        OemRemSavingsService $savingsService
    ) {
        $this->productFinderService = $productFinderService;
        $this->savingsService = $savingsService;
    }


    public function getFunctions(): array
    {
        return [
            new TwigFunction('TopdataLinkedOemRemSW6_getMatchingRemProductsForOemProductsInCart', [$this, 'TopdataLinkedOemRemSW6_getMatchingRemProductsForOemProductsInCart'], ['needs_context' => true]),
            // new TwigFunction('TopdataLinkedOemRemSW6_getSavingsOverOem', [$this, 'TopdataLinkedOemRemSW6_getSavingsOverOem'], ['needs_context' => true]),
        ];
    }

    /**
     * 11/2023 created
     */
    public function TopdataLinkedOemRemSW6_getMatchingRemProductsForOemProductsInCart(array $twigContext, Cart $cart)
    {
        $productIds = self::_getProductIdsFromCart($cart);
        $salesChannelContext = self::_getSalesChannelContext($twigContext);
        // dd($this->oemRemService->getMatchingRemProductsFlat($productIds, $salesChannelContext));

        return $this->productFinderService->findMatchingRemProductsFlat($productIds, $salesChannelContext);
    }

//    /**
//     * 11/2023 created
//     * 07/2025 removed (unused)
//     *
//     * @param array $twigContext
//     * @param SalesChannelProductEntity $remProduct
//     * @return ?SavingsOverOemDTO associated OEM product with the highest saving / lowest price
//     */
//    public function TopdataLinkedOemRemSW6_getSavingsOverOem(array $twigContext, SalesChannelProductEntity $remProduct, string $currencyId): ?SavingsOverOemDTO
//    {
//        $salesChannelContext = self::_getSalesChannelContext($twigContext);
//
//        return $this->savingsService->getSavingsOverOem($remProduct, $salesChannelContext, $currencyId);
//    }


    private static function _getContext($twigContext): Context
    {
        $context = $twigContext['context'] ?? null;

        if ($context instanceof Context) {
            return $context;
        }

        if ($context instanceof SalesChannelContext) {
            return $context->getContext();
        }

        throw new \InvalidArgumentException('Twig context must contain a valid Shopware context');

    }

    private static function _getSalesChannelContext($twigContext): SalesChannelContext
    {
        $context = $twigContext['context'] ?? null;

        if ($context instanceof SalesChannelContext) {
            return $context;
        }

        throw new \InvalidArgumentException('Twig context must contain a valid SalesChannelContext');
    }

    /**
     * helper
     *
     * 11/2023 created
     *
     * @param Cart $cart
     * @return string[] product ids
     */
    private static function _getProductIdsFromCart(Cart $cart): array
    {
        $productIds = [];
        $cart->getLineItems()->map(function (LineItem $x) use (&$productIds) {
            if ($x->getType() === LineItem::PRODUCT_LINE_ITEM_TYPE) {
                $productIds[] = $x->getReferencedId();
            }
        });

        return $productIds;
    }

}
