<?php declare(strict_types=1);

namespace Topdata\TopdataLinkedOemRemSW6;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\InstallContext;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Topdata\TopdataLinkedOemRemSW6\Foundation\DependencyInjection\TopConfigRegistryCompilerPass;
use Topdata\TopdataLinkedOemRemSW6\Constants\SavingsDisplayModeConstants;

/**
 * 11/2023 created
 */
class TopdataLinkedOemRemSW6 extends Plugin
{


    const MAPPINGS = [
        // TODO...
    ];

    /**
     * 11/2024 created
     */
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        // ---- register the plugin in Topdata Configration Center's TopConfigRegistry
        if(class_exists(TopConfigRegistryCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigRegistryCompilerPass(__CLASS__, self::MAPPINGS));
        }
    }


    /**
     * 12/2023 created
     *
     * @return string[] list of sw6Ids
     * @throws \Doctrine\DBAL\Exception
     */
    private function _findPropertyGroupSw6Ids(Connection $connection, string $propertyGroupName, int $max = 50)
    {
        $sql = "
            SELECT DISTINCT(LOWER(HEX(`property_group_id`))) AS `property_group_id`, `name`
                FROM `property_group_translation`
                WHERE `name` = :propertyGroupName
                ORDER BY created_at DESC    
                LIMIT $max
        ";

        return $connection->fetchFirstColumn($sql, [
            'propertyGroupName' => $propertyGroupName,
        ]);
    }


    public function install(InstallContext $installContext): void
    {
        parent::install($installContext);

        // ---- default value for savings display mode
        $config = $this->container->get(SystemConfigService::class);
        $config->set('TopdataLinkedOemRemSW6.config.savingsDisplayMode', SavingsDisplayModeConstants::MONEY_NOT_ROUNDED);

        // ---- property group sw6Ids
        /** @var Connection $connection */
        $connection = $this->container->get(Connection::class);
        /** @var SystemConfigService $systemConfigService */
        $systemConfigService = $this->container->get(SystemConfigService::class);


        // ---- try to automatically fill the plugin settings with the correct ids
        $map = [
            'TopdataLinkedOemRemSW6.config.propertyGroupIdReferenceOem' => 'Reference OEM',
            'TopdataLinkedOemRemSW6.config.propertyGroupIdMpn'          => 'MPN',
            'TopdataLinkedOemRemSW6.config.propertyGroupIdCapacity'     => 'Kapazität',
        ];
        foreach ($map as $systemConfigName => $germanTranslatedName) {
            $ids = $this->_findPropertyGroupSw6Ids($connection, $germanTranslatedName);
            if(!empty($ids)) {
                $id = $ids[0];
                $systemConfigService->set($systemConfigName, $id);
            }
        }


    }

    /**
     * When uninstalling a plugin, the user is asked if he really wants to delete all
     * the plugin data. The method keepUserData of the UninstallContext will provide
     * the users decision. If keepUserData returns true, you should not remove important
     * data of your plugin, the user wants to keep them.
     */
    public function uninstall(UninstallContext $uninstallContext): void
    {
        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }

        $connection = $this->container->get(Connection::class);
        if (!$connection) {
            return;
        }

        // ---- drop tables

        $connection->executeStatement('
            DROP TABLE IF EXISTS topdata_lor_oem_to_rem;
        ');

    }

}