<?php declare(strict_types=1);


namespace Topdata\TopdataLinkedOemRemSW6\Command;

use Shopware\Core\Framework\Api\Context\SystemSource;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\SalesChannel\Context\CachedSalesChannelContextFactory;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Topdata\TopdataLinkedOemRemSW6\Foundation\Command\AbstractTopdataCommand;
use Topdata\TopdataLinkedOemRemSW6\Foundation\Util\CliLogger;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemProductFinderService;
use Topdata\TopdataLinkedOemRemSW6\Service\SalesChannelSelectionService;

/**
 * 11/2023 created
 */
#[AsCommand(
    name: 'topdata:linked-oem-rem:test-fetch-linked-products',
    description: 'test fetch linked products'
)]
class Command_TestFetchLinkedProducts extends AbstractTopdataCommand
{


    public function __construct(
        private readonly OemRemProductFinderService      $oemRemProductFinderService,
        private readonly SalesChannelSelectionService     $salesChannelSelectionService,
    )
    {
        parent::__construct();
    }


    /**
     * ==== MAIN ====
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $oemProductIds = [
            '00427c2d5bcd445f9fe33afccea249b7',
            '0054dab2b71f49d7bc2312b8da566d02'
        ];

        $salesChannelContext = $this->salesChannelSelectionService->askToGetSalesChannelContext();

        $map = $this->oemRemProductFinderService->findMatchingRemProductsMap($oemProductIds, $salesChannelContext);

        CliLogger::getCliStyle()->dumpDict($map);

        $this->done();

        return Command::SUCCESS;
    }


}
